/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;

public final class EnterAction
extends AnAction {
    public void actionPerformed(AnActionEvent e2) {
        ThumbnailView view2 = ThumbnailViewActionUtil.getVisibleThumbnailView(e2);
        if (view2 != null) {
            VirtualFile[] selection = view2.getSelection();
            if (selection.length == 1 && selection[0].isDirectory()) {
                view2.setRoot(selection[0]);
            } else if (selection.length > 0) {
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)view2.getProject());
                ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
                for (VirtualFile file2 : selection) {
                    if (!typeManager.isImage(file2)) continue;
                    fileEditorManager.openFile(file2, false);
                }
            }
        }
    }

    public void update(AnActionEvent e2) {
        super.update(e2);
        if (ThumbnailViewActionUtil.setEnabled(e2)) {
            Presentation presentation = e2.getPresentation();
            ThumbnailView view2 = ThumbnailViewActionUtil.getVisibleThumbnailView(e2);
            VirtualFile[] selection = view2.getSelection();
            if (selection.length > 0) {
                if (selection.length == 1 && selection[0].isDirectory()) {
                    presentation.setVisible(true);
                } else {
                    boolean notImages = false;
                    ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
                    for (VirtualFile file2 : selection) {
                        notImages |= !typeManager.isImage(file2);
                    }
                    presentation.setEnabled(!notImages);
                    presentation.setVisible(false);
                }
            } else {
                presentation.setVisible(false);
                presentation.setEnabled(false);
            }
        }
    }
}

