/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import javax.swing.JComponent;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;
import org.intellij.images.thumbnail.actions.FilterByThemeAction;
import org.intellij.images.thumbnail.actions.ThemeFilter;
import org.jetbrains.annotations.NotNull;

public final class FilterByThemeComboBoxAction
extends ComboBoxAction {
    public void update(AnActionEvent e2) {
        Project project2 = e2.getProject();
        ThumbnailView view2 = ThumbnailViewActionUtil.getVisibleThumbnailView(e2);
        boolean hasApplicableExtension = Arrays.stream(ThemeFilter.EP_NAME.getExtensions()).allMatch(filter2 -> project2 != null && filter2.isApplicableToProject(project2));
        e2.getPresentation().setVisible(view2 != null && hasApplicableExtension);
        ThemeFilter filter3 = view2 != null ? view2.getFilter() : null;
        e2.getPresentation().setText(filter3 == null ? "All" : filter3.getDisplayName());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new FilterByThemeAction(new ThemeFilter(){

            @Override
            public String getDisplayName() {
                return "All";
            }

            @Override
            public boolean accepts(VirtualFile file2) {
                return true;
            }

            @Override
            public boolean isApplicableToProject(Project project2) {
                return true;
            }
        }));
        for (ThemeFilter filter2 : (ThemeFilter[])ThemeFilter.EP_NAME.getExtensions()) {
            group.add((AnAction)new FilterByThemeAction(filter2));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/actions/FilterByThemeComboBoxAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }
}

