/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.ui.ImageComponent;

public class ImageComponentUI
extends ComponentUI {
    private BufferedImage pattern;

    private ImageComponentUI(JComponent c2) {
        c2.addPropertyChangeListener(evt -> {
            String name = evt.getPropertyName();
            if ("TransparencyChessboard.blackColor".equals(name) || "TransparencyChessboard.whiteColor".equals(name) || "TransparencyChessboard.cellSize".equals(name)) {
                this.pattern = null;
            }
        });
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        ImageDocument document;
        BufferedImage image;
        ImageComponent ic2 = (ImageComponent)c2;
        if (ic2 != null && (image = (document = ic2.getDocument()).getValue()) != null) {
            if (ic2.isFileSizeVisible()) {
                ImageComponentUI.paintBorder(g2, ic2);
            }
            Dimension size = ic2.getCanvasSize();
            Graphics igc = g2.create(2, 2, size.width, size.height);
            if (ic2.isTransparencyChessboardVisible() && image.getTransparency() != 1) {
                this.paintChessboard(igc, ic2);
            }
            ImageComponentUI.paintImage(igc, ic2);
            if (ic2.isGridVisible()) {
                ImageComponentUI.paintGrid(igc, ic2);
            }
            igc.dispose();
        }
    }

    private static void paintBorder(Graphics g2, ImageComponent ic2) {
        Dimension size = ic2.getSize();
        g2.setColor(ic2.getTransparencyChessboardBlackColor());
        g2.drawRect(0, 0, size.width - 1, size.height - 1);
    }

    private void paintChessboard(Graphics g2, ImageComponent ic2) {
        Dimension size = ic2.getCanvasSize();
        int cellSize = ic2.getTransparencyChessboardCellSize();
        int patternSize = 2 * cellSize;
        if (this.pattern == null) {
            this.pattern = UIUtil.createImage((Graphics)g2, (int)patternSize, (int)patternSize, (int)2);
            Graphics imageGraphics = this.pattern.getGraphics();
            imageGraphics.setColor(ic2.getTransparencyChessboardWhiteColor());
            imageGraphics.fillRect(0, 0, patternSize, patternSize);
            imageGraphics.setColor(ic2.getTransparencyChessboardBlackColor());
            imageGraphics.fillRect(0, cellSize, cellSize, cellSize);
            imageGraphics.fillRect(cellSize, 0, cellSize, cellSize);
        }
        ((Graphics2D)g2).setPaint(new TexturePaint(this.pattern, new Rectangle(0, 0, patternSize, patternSize)));
        g2.fillRect(0, 0, size.width, size.height);
    }

    private static void paintImage(Graphics g2, ImageComponent ic2) {
        ImageDocument document = ic2.getDocument();
        Dimension size = ic2.getCanvasSize();
        Graphics2D g2d = (Graphics2D)g2;
        RenderingHints oldHints = g2d.getRenderingHints();
        BufferedImage image = ic2.getDocument().getValue();
        BufferedImage renderer = document.getValue();
        if (size.width > image.getWidth() && size.height > image.getHeight()) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        g2.drawImage(renderer, 0, 0, size.width, size.height, ic2);
        g2d.setRenderingHints(oldHints);
    }

    private static void paintGrid(Graphics g2, ImageComponent ic2) {
        int imageHeight;
        double zoomY;
        Dimension size = ic2.getCanvasSize();
        BufferedImage image = ic2.getDocument().getValue();
        int imageWidth = image.getWidth();
        double zoomX = (double)size.width / (double)imageWidth;
        double zoomFactor = (zoomX + (zoomY = (double)size.height / (double)(imageHeight = image.getHeight()))) / 2.0;
        if (zoomFactor >= (double)ic2.getGridLineZoomFactor()) {
            int ls;
            g2.setColor(ic2.getGridLineColor());
            for (int dx = ls = ic2.getGridLineSpan(); dx < imageWidth; dx += ls) {
                UIUtil.drawLine((Graphics)g2, (int)((int)((double)dx * zoomX)), (int)0, (int)((int)((double)dx * zoomX)), (int)size.height);
            }
            for (int dy = ls; dy < imageHeight; dy += ls) {
                UIUtil.drawLine((Graphics)g2, (int)0, (int)((int)((double)dy * zoomY)), (int)size.width, (int)((int)((double)dy * zoomY)));
            }
        }
    }

    public static ComponentUI createUI(JComponent c2) {
        return new ImageComponentUI(c2);
    }
}

