/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import icons.ImagesIcons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.intellij.images.ImagesBundle;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.ui.ImageComponent;
import org.intellij.images.ui.ThumbnailComponent;
import org.jetbrains.annotations.NonNls;

public class ThumbnailComponentUI
extends ComponentUI {
    @NonNls
    private static final String DOTS = "...";
    @NonNls
    private static final String THUMBNAIL_COMPONENT_ERROR_STRING = "ThumbnailComponent.errorString";
    private static final Color LINE_COLOR = new Color(142, 168, 206);
    private static final Color PNG_COLOR = new Color(128, 0, 128);
    private static final Color GIF_COLOR = new Color(0, 128, 0);
    private static final Color JPG_COLOR = new Color(128, 128, 0);
    private static final Color BMP_COLOR = new Color(0, 0, 128);
    private static final ThumbnailComponentUI ui = new ThumbnailComponentUI();

    @Override
    public void paint(Graphics g2, JComponent c2) {
        ThumbnailComponent tc = (ThumbnailComponent)c2;
        if (tc != null) {
            UISettings.setupAntialiasing((Graphics)g2);
            this.paintBackground(g2, tc);
            if (tc.isDirectory()) {
                this.paintDirectory(g2, tc);
            } else {
                this.paintImageThumbnail(g2, tc);
            }
            if (tc.isDirectory() || tc.getImageComponent().isFileNameVisible()) {
                this.paintFileName(g2, tc);
            }
        }
    }

    private void paintDirectory(Graphics g2, ThumbnailComponent tc) {
        ImagesIcons.ThumbnailDirectory.paintIcon(tc, g2, 5, 5);
        int imagesCount = tc.getImagesCount();
        if (imagesCount > 0) {
            String title = ImagesBundle.message("icons.count", imagesCount);
            Font font = ThumbnailComponentUI.getSmallFont();
            FontMetrics fontMetrics = g2.getFontMetrics(font);
            g2.setColor(Color.BLACK);
            g2.setFont(font);
            g2.drawString(title, 5 + (ImagesIcons.ThumbnailDirectory.getIconWidth() - fontMetrics.stringWidth(title)) / 2, ImagesIcons.ThumbnailDirectory.getIconHeight() / 2 + fontMetrics.getAscent());
        }
    }

    private void paintImageThumbnail(Graphics g2, ThumbnailComponent tc) {
        ImageDocument document;
        BufferedImage image;
        ImageComponent imageComponent = tc.getImageComponent();
        if (imageComponent.isFileSizeVisible()) {
            ImagesIcons.ThumbnailBlank.paintIcon(tc, g2, 5, 5);
        }
        if ((image = (document = imageComponent.getDocument()).getValue()) != null) {
            this.paintImage(g2, tc);
        } else {
            this.paintError(g2, tc);
        }
        if (imageComponent.isFileSizeVisible()) {
            this.paintFileSize(g2, tc);
        }
    }

    private void paintBackground(Graphics g2, ThumbnailComponent tc) {
        Dimension size = tc.getSize();
        g2.setColor(tc.getBackground());
        g2.fillRect(0, 0, size.width, size.height);
    }

    private void paintImage(Graphics g2, ThumbnailComponent tc) {
        ImageComponent imageComponent = tc.getImageComponent();
        int blankHeight = ImagesIcons.ThumbnailBlank.getIconHeight();
        if (imageComponent.isFileSizeVisible()) {
            blankHeight -= this.paintImageCaps(g2, imageComponent);
            blankHeight -= this.paintFormatText(tc, g2);
        }
        this.paintThumbnail(g2, imageComponent, blankHeight);
    }

    private int paintImageCaps(Graphics g2, ImageComponent imageComponent) {
        String description = imageComponent.getDescription();
        Font font = ThumbnailComponentUI.getSmallFont();
        FontMetrics fontMetrics = g2.getFontMetrics(font);
        g2.setColor(Color.BLACK);
        g2.setFont(font);
        g2.drawString(description, 8, 7 + fontMetrics.getAscent());
        return fontMetrics.getHeight();
    }

    private int paintFormatText(ThumbnailComponent tc, Graphics g2) {
        Font font = ThumbnailComponentUI.getSmallFont().deriveFont(1);
        FontMetrics fontMetrics = g2.getFontMetrics(font);
        String format = tc.getFormat().toUpperCase();
        int stringWidth = fontMetrics.stringWidth(format);
        int x2 = ImagesIcons.ThumbnailBlank.getIconWidth() - stringWidth + 2;
        int y2 = ImagesIcons.ThumbnailBlank.getIconHeight() - fontMetrics.getHeight() + 4;
        g2.setColor(LINE_COLOR);
        g2.drawLine(x2 - 3, y2 - 1, x2 + stringWidth + 1, y2 - 1);
        g2.drawLine(x2 - 4, y2, x2 - 4, y2 + fontMetrics.getHeight() - 1);
        g2.setColor(this.getFormatColor(format));
        g2.setFont(font);
        g2.drawString(format, x2, y2 + fontMetrics.getAscent());
        return fontMetrics.getHeight();
    }

    private Color getFormatColor(String format) {
        if ("PNG".equals(format)) {
            return PNG_COLOR;
        }
        if ("GIF".equals(format)) {
            return GIF_COLOR;
        }
        if ("JPG".equals(format) || "JPEG".equals(format)) {
            return JPG_COLOR;
        }
        if ("BMP".equals(format) || "WBMP".equals(format)) {
            return BMP_COLOR;
        }
        return Color.BLACK;
    }

    private void paintThumbnail(Graphics g2, ImageComponent imageComponent, int blankHeight) {
        int maxWidth = ImagesIcons.ThumbnailBlank.getIconWidth() - 10;
        int maxHeight = blankHeight - 10;
        BufferedImage image = imageComponent.getDocument().getValue();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (imageWidth > maxWidth || imageHeight > maxHeight) {
            double proportion;
            if (imageWidth > maxWidth) {
                proportion = (double)maxWidth / (double)imageWidth;
                imageWidth = maxWidth;
                imageHeight = (int)((double)imageHeight * proportion);
            }
            if (imageHeight > maxHeight) {
                proportion = (double)maxHeight / (double)imageHeight;
                imageHeight = maxHeight;
                imageWidth = (int)((double)imageWidth * proportion);
            }
        }
        imageComponent.setCanvasSize(imageWidth, imageHeight);
        Dimension size = imageComponent.getSize();
        int x2 = 5 + (ImagesIcons.ThumbnailBlank.getIconWidth() - size.width) / 2;
        int y2 = 5 + (ImagesIcons.ThumbnailBlank.getIconHeight() - size.height) / 2;
        imageComponent.paint(g2.create(x2, y2, size.width, size.height));
    }

    private void paintFileName(Graphics g2, ThumbnailComponent tc) {
        String fileName;
        Font font = UIUtil.getLabelFont();
        FontMetrics fontMetrics = g2.getFontMetrics(font);
        g2.setFont(font);
        g2.setColor(tc.getForeground());
        String title = fileName = tc.getFileName();
        while (fontMetrics.stringWidth(title) > ImagesIcons.ThumbnailBlank.getIconWidth() - 8) {
            title = title.substring(0, title.length() - 1);
        }
        if (fileName.equals(title)) {
            g2.drawString(fileName, 6 + (ImagesIcons.ThumbnailBlank.getIconWidth() - 2 - fontMetrics.stringWidth(title)) / 2, ImagesIcons.ThumbnailBlank.getIconHeight() + 8 + fontMetrics.getAscent());
        } else {
            int dotsWidth = fontMetrics.stringWidth(DOTS);
            while (fontMetrics.stringWidth(title) > ImagesIcons.ThumbnailBlank.getIconWidth() - 8 - dotsWidth) {
                title = title.substring(0, title.length() - 1);
            }
            g2.drawString(title + DOTS, 6, ImagesIcons.ThumbnailBlank.getIconHeight() + 8 + fontMetrics.getAscent());
        }
    }

    private void paintFileSize(Graphics g2, ThumbnailComponent tc) {
        Font font = ThumbnailComponentUI.getSmallFont();
        FontMetrics fontMetrics = g2.getFontMetrics(font);
        g2.setColor(Color.BLACK);
        g2.setFont(font);
        g2.drawString(tc.getFileSizeText(), 8, ImagesIcons.ThumbnailBlank.getIconHeight() + 4 - fontMetrics.getHeight() + fontMetrics.getAscent());
    }

    private void paintError(Graphics g2, ThumbnailComponent tc) {
        Font font = ThumbnailComponentUI.getSmallFont();
        FontMetrics fontMetrics = g2.getFontMetrics(font);
        Messages.getErrorIcon().paintIcon(tc, g2, 5 + (ImagesIcons.ThumbnailBlank.getIconWidth() - Messages.getErrorIcon().getIconWidth()) / 2, 5 + (ImagesIcons.ThumbnailBlank.getIconHeight() - Messages.getErrorIcon().getIconHeight()) / 2);
        String error = this.getSubmnailComponentErrorString();
        g2.setColor((Color)JBColor.RED);
        g2.setFont(font);
        g2.drawString(error, 8, 8 + fontMetrics.getAscent());
    }

    private String getSubmnailComponentErrorString() {
        return UIManager.getString(THUMBNAIL_COMPONENT_ERROR_STRING);
    }

    private static Font getSmallFont() {
        Font labelFont = UIUtil.getLabelFont();
        return labelFont.deriveFont(labelFont.getSize2D() - 2.0f);
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Font labelFont = UIUtil.getLabelFont();
        FontMetrics fontMetrics = c2.getFontMetrics(labelFont);
        return new Dimension(ImagesIcons.ThumbnailBlank.getIconWidth() + 10, ImagesIcons.ThumbnailBlank.getIconHeight() + fontMetrics.getHeight() + 15);
    }

    public static ComponentUI createUI(JComponent c2) {
        return ui;
    }

    static {
        UIManager.getDefaults().put(THUMBNAIL_COMPONENT_ERROR_STRING, ImagesBundle.message("thumbnails.component.error.text", new Object[0]));
    }
}

