/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import org.intellij.lang.regexp.inspection.RegExpFactory;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RepeatedSpaceInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Consecutive spaces" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection", "getDisplayName"));
        }
        return "Consecutive spaces";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection", "buildVisitor"));
        }
        RepeatedSpaceVisitor repeatedSpaceVisitor = new RepeatedSpaceVisitor(holder);
        if (repeatedSpaceVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection", "buildVisitor"));
        }
        return repeatedSpaceVisitor;
    }

    private static class RepeatedSpaceFix
    implements LocalQuickFix {
        private final int myCount;

        public RepeatedSpaceFix(int count) {
            this.myCount = count;
        }

        @Nls
        @NotNull
        public String getName() {
            String string2 = "Replace with ' {" + this.myCount + "}'";
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection$RepeatedSpaceFix", "getName"));
            }
            return string2;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with space and repeated quantifier" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection$RepeatedSpaceFix", "getFamilyName"));
            }
            return "Replace with space and repeated quantifier";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection$RepeatedSpaceFix", "applyFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/intellij/lang/regexp/inspection/RepeatedSpaceInspection$RepeatedSpaceFix", "applyFix"));
            }
            PsiElement element = descriptor2.getPsiElement();
            if (!(element instanceof RegExpBranch)) {
                return;
            }
            TextRange range = descriptor2.getTextRangeInElement();
            StringBuilder text2 = new StringBuilder();
            PsiElement[] children2 = element.getChildren();
            boolean inserted = false;
            for (PsiElement child : children2) {
                if (!range.contains(child.getStartOffsetInParent())) {
                    text2.append(child.getText());
                    continue;
                }
                if (inserted) continue;
                text2.append(" {").append(range.getLength()).append('}');
                inserted = true;
            }
            element.replace((PsiElement)RegExpFactory.createBranchFromText(text2, element));
        }
    }

    private static class RepeatedSpaceVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;
        private int myCount = 0;
        private RegExpChar myFirstChar = null;
        private boolean quoted = false;

        public RepeatedSpaceVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar aChar) {
            if (!this.quoted && !(aChar.getParent() instanceof RegExpClass) && aChar.getType() == RegExpChar.Type.CHAR && aChar.getValue() == 32) {
                if (this.myFirstChar == null) {
                    this.myFirstChar = aChar;
                }
                ++this.myCount;
            } else {
                super.visitRegExpChar(aChar);
            }
        }

        public void visitWhiteSpace(PsiWhiteSpace space) {
            super.visitWhiteSpace(space);
            String text2 = space.getText();
            if (text2.equals("\\Q")) {
                this.quoted = true;
            } else if (text2.equals("\\E")) {
                this.quoted = false;
            }
            this.myFirstChar = null;
            this.myCount = 0;
        }

        @Override
        public void visitRegExpClass(RegExpClass expClass) {
            super.visitRegExpClass(expClass);
            this.myFirstChar = null;
            this.myCount = 0;
        }

        @Override
        public void visitRegExpElement(RegExpElement element) {
            super.visitRegExpElement(element);
            if (this.myFirstChar != null && this.myCount > 1) {
                int offset = this.myFirstChar.getStartOffsetInParent();
                String message2 = this.myCount + " consecutive spaces in RegExp";
                this.myHolder.registerProblem(this.myFirstChar.getParent(), new TextRange(offset, offset + this.myCount), message2, new LocalQuickFix[]{new RepeatedSpaceFix(this.myCount)});
            }
            this.myFirstChar = null;
            this.myCount = 0;
        }
    }
}

