/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpBackrefImpl
extends RegExpElementImpl
implements RegExpBackref {
    public RegExpBackrefImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public int getIndex() {
        String s2 = this.getUnescapedText();
        assert (s2.charAt(0) == '\\');
        return Integer.parseInt(s2.substring(1));
    }

    @Override
    public void accept(RegExpElementVisitor visitor2) {
        visitor2.visitRegExpBackref(this);
    }

    @Override
    public RegExpGroup resolve() {
        final int index = this.getIndex();
        PsiElementProcessor.FindFilteredElement processor2 = new PsiElementProcessor.FindFilteredElement(new PsiElementFilter(){
            int groupCount;

            public boolean isAccepted(PsiElement element) {
                if (element instanceof RegExpGroup && ((RegExpGroup)element).isCapturing() && ++this.groupCount == index) {
                    return true;
                }
                return element == RegExpBackrefImpl.this;
            }
        });
        PsiTreeUtil.processElements((PsiElement)this.getContainingFile(), (PsiElementProcessor)processor2);
        if (processor2.getFoundElement() instanceof RegExpGroup) {
            return (RegExpGroup)processor2.getFoundElement();
        }
        return null;
    }

    @Override
    public PsiReference getReference() {
        return new PsiReference(){

            public PsiElement getElement() {
                return RegExpBackrefImpl.this;
            }

            public TextRange getRangeInElement() {
                return TextRange.from((int)0, (int)this.getElement().getTextLength());
            }

            @NotNull
            public String getCanonicalText() {
                String string2 = this.getElement().getText();
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpBackrefImpl$2", "getCanonicalText"));
                }
                return string2;
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                throw new IncorrectOperationException();
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/regexp/psi/impl/RegExpBackrefImpl$2", "bindToElement"));
                }
                throw new IncorrectOperationException();
            }

            public boolean isReferenceTo(PsiElement element) {
                return Comparing.equal((Object)element, (Object)this.resolve());
            }

            public boolean isSoft() {
                return false;
            }

            public PsiElement resolve() {
                return RegExpBackrefImpl.this.resolve();
            }

            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpBackrefImpl$2", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
        };
    }
}

