/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpNamedGroupRefImpl
extends RegExpElementImpl
implements RegExpNamedGroupRef {
    private static final TokenSet RUBY_GROUP_REF_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.RUBY_NAMED_GROUP_REF, RegExpTT.RUBY_QUOTED_NAMED_GROUP_REF, RegExpTT.RUBY_NAMED_GROUP_CALL, RegExpTT.RUBY_QUOTED_NAMED_GROUP_CALL});
    private static final TokenSet GROUP_REF_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.PYTHON_NAMED_GROUP_REF, RegExpTT.RUBY_NAMED_GROUP_REF, RegExpTT.RUBY_QUOTED_NAMED_GROUP_REF, RegExpTT.RUBY_NAMED_GROUP_CALL, RegExpTT.RUBY_QUOTED_NAMED_GROUP_CALL});

    public RegExpNamedGroupRefImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(RegExpElementVisitor visitor2) {
        visitor2.visitRegExpNamedGroupRef(this);
    }

    @Override
    @Nullable
    public RegExpGroup resolve() {
        PsiElementProcessor.FindFilteredElement processor2 = new PsiElementProcessor.FindFilteredElement(new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                if (!(element instanceof RegExpGroup)) {
                    return false;
                }
                RegExpGroup group = (RegExpGroup)element;
                return group.isAnyNamedGroup() && Comparing.equal((String)RegExpNamedGroupRefImpl.this.getGroupName(), (String)group.getGroupName());
            }
        });
        PsiTreeUtil.processElements((PsiElement)this.getContainingFile(), (PsiElementProcessor)processor2);
        return (RegExpGroup)processor2.getFoundElement();
    }

    @Override
    @Nullable
    public String getGroupName() {
        ASTNode nameNode = this.getNode().findChildByType(RegExpTT.NAME);
        return nameNode != null ? nameNode.getText() : null;
    }

    @Override
    public boolean isPythonNamedGroupRef() {
        return this.getNode().findChildByType(RegExpTT.PYTHON_NAMED_GROUP_REF) != null;
    }

    @Override
    public boolean isRubyNamedGroupRef() {
        ASTNode node = this.getNode();
        return node.findChildByType(RUBY_GROUP_REF_TOKENS) != null;
    }

    @Override
    public boolean isNamedGroupRef() {
        return this.getNode().findChildByType(RegExpTT.RUBY_NAMED_GROUP_REF) != null;
    }

    @Override
    public PsiReference getReference() {
        return new PsiReference(){

            public PsiElement getElement() {
                return RegExpNamedGroupRefImpl.this;
            }

            public TextRange getRangeInElement() {
                ASTNode groupNode = RegExpNamedGroupRefImpl.this.getNode().findChildByType(GROUP_REF_TOKENS);
                assert (groupNode != null);
                return new TextRange(groupNode.getTextLength(), RegExpNamedGroupRefImpl.this.getTextLength() - 1);
            }

            public PsiElement resolve() {
                return RegExpNamedGroupRefImpl.this.resolve();
            }

            @NotNull
            public String getCanonicalText() {
                String string2 = this.getRangeInElement().substring(RegExpNamedGroupRefImpl.this.getText());
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpNamedGroupRefImpl$2", "getCanonicalText"));
                }
                return string2;
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                throw new UnsupportedOperationException();
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/regexp/psi/impl/RegExpNamedGroupRefImpl$2", "bindToElement"));
                }
                throw new UnsupportedOperationException();
            }

            public boolean isReferenceTo(PsiElement element) {
                return this.resolve() == element;
            }

            @NotNull
            public Object[] getVariants() {
                PsiElementProcessor.CollectFilteredElements processor2 = new PsiElementProcessor.CollectFilteredElements(new PsiElementFilter(){

                    public boolean isAccepted(PsiElement element) {
                        if (!(element instanceof RegExpGroup)) {
                            return false;
                        }
                        RegExpGroup regExpGroup = (RegExpGroup)element;
                        return regExpGroup.isAnyNamedGroup();
                    }
                });
                PsiTreeUtil.processElements((PsiElement)RegExpNamedGroupRefImpl.this.getContainingFile(), (PsiElementProcessor)processor2);
                Object[] objectArray = processor2.toArray();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpNamedGroupRefImpl$2", "getVariants"));
                }
                return objectArray;
            }

            public boolean isSoft() {
                return false;
            }
        };
    }
}

