/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GroupSurrounder
implements Surrounder {
    private final String myTitle;
    private final String myGroupStart;

    public GroupSurrounder(String title, String groupStart) {
        this.myTitle = title;
        this.myGroupStart = groupStart;
    }

    public String getTemplateDescription() {
        return this.myTitle;
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/intellij/lang/regexp/surroundWith/GroupSurrounder", "isApplicable"));
        }
        return elements.length == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements) == elements[0].getParent();
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/regexp/surroundWith/GroupSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/lang/regexp/surroundWith/GroupSurrounder", "surroundElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/intellij/lang/regexp/surroundWith/GroupSurrounder", "surroundElements"));
        }
        assert (elements.length == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements) == elements[0].getParent());
        PsiElement e2 = elements[0];
        ASTNode node = e2.getNode();
        assert (node != null);
        ASTNode parent = node.getTreeParent();
        StringBuilder s2 = new StringBuilder();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            PsiElement element = elements[i2];
            if (element instanceof RegExpElementImpl) {
                s2.append(((RegExpElementImpl)element).getUnescapedText());
            } else {
                s2.append(element.getText());
            }
            if (i2 <= 0) continue;
            ASTNode child = element.getNode();
            assert (child != null);
            parent.removeChild(child);
        }
        PsiFileFactory factory2 = PsiFileFactory.getInstance((Project)project2);
        PsiFile f2 = factory2.createFileFromText("dummy.regexp", (FileType)RegExpFileType.INSTANCE, (CharSequence)this.makeReplacement(s2));
        RegExpPattern pattern = (RegExpPattern)PsiTreeUtil.getChildOfType((PsiElement)f2, RegExpPattern.class);
        assert (pattern != null);
        RegExpAtom element = pattern.getBranches()[0].getAtoms()[0];
        if (GroupSurrounder.isInsideStringLiteral(e2)) {
            Document doc = editor.getDocument();
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(doc);
            TextRange tr = e2.getTextRange();
            doc.replaceString(tr.getStartOffset(), tr.getEndOffset(), (CharSequence)StringUtil.escapeStringCharacters((String)element.getText()));
            return TextRange.from((int)e2.getTextRange().getEndOffset(), (int)0);
        }
        PsiElement n2 = e2.replace((PsiElement)element);
        return TextRange.from((int)n2.getTextRange().getEndOffset(), (int)0);
    }

    private static boolean isInsideStringLiteral(PsiElement context2) {
        while (context2 != null) {
            if (RegExpElementImpl.isLiteralExpression(context2)) {
                return true;
            }
            context2 = context2.getContext();
        }
        return false;
    }

    protected String makeReplacement(StringBuilder s2) {
        return this.myGroupStart + s2 + ")";
    }
}

