/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpOptions;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpPosixBracketExpression;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.RegExpPyCondRef;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.intellij.lang.regexp.psi.RegExpRecursiveElementVisitor;
import org.intellij.lang.regexp.psi.RegExpSetOptions;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.intellij.lang.regexp.validation.RemoveRedundantEscapeAction;
import org.intellij.lang.regexp.validation.SimplifyQuantifierAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegExpAnnotator
extends RegExpElementVisitor
implements Annotator {
    private static final Set<String> POSIX_CHARACTER_CLASSES = ContainerUtil.newHashSet((Object[])new String[]{"alnum", "alpha", "ascii", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "word", "xdigit"});
    private AnnotationHolder myHolder;
    private final RegExpLanguageHosts myLanguageHosts = RegExpLanguageHosts.getInstance();

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/intellij/lang/regexp/validation/RegExpAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/validation/RegExpAnnotator", "annotate"));
        }
        assert (this.myHolder == null) : "unsupported concurrent annotator invocation";
        try {
            this.myHolder = holder;
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitRegExpSetOptions(RegExpSetOptions options) {
        this.checkValidFlag(options.getOnOptions(), false);
        this.checkValidFlag(options.getOffOptions(), true);
    }

    private void checkValidFlag(@Nullable RegExpOptions options, boolean skipMinus) {
        int start2;
        if (options == null) {
            return;
        }
        String text2 = options.getText();
        int length = text2.length();
        for (int i2 = start2 = skipMinus ? 1 : 0; i2 < length; ++i2) {
            int c2 = text2.codePointAt(i2);
            if (Character.isBmpCodePoint(c2) && this.myLanguageHosts.supportsInlineOptionFlag((char)c2, options)) continue;
            int offset = options.getTextOffset() + i2;
            this.myHolder.createErrorAnnotation(new TextRange(offset, offset + 1), "Unknown inline option flag");
        }
    }

    @Override
    public void visitRegExpCharRange(RegExpCharRange range) {
        RegExpChar from = range.getFrom();
        RegExpChar to = range.getTo();
        if (to != null) {
            this.checkRange(range, from.getValue(), to.getValue());
        }
    }

    private void checkRange(RegExpCharRange range, int fromCodePoint, int toCodePoint) {
        int nextSiblingValue;
        PsiElement nextSibling;
        int prevSiblingValue;
        PsiElement prevSibling;
        if (fromCodePoint == -1 || toCodePoint == -1) {
            return;
        }
        int errorStart = range.getTextOffset();
        int errorEnd = errorStart + range.getTextLength();
        if (!Character.isSupplementaryCodePoint(fromCodePoint) && Character.isLowSurrogate((char)fromCodePoint) && (prevSibling = range.getPrevSibling()) instanceof RegExpChar && !Character.isSupplementaryCodePoint(prevSiblingValue = ((RegExpChar)prevSibling).getValue()) && Character.isHighSurrogate((char)prevSiblingValue)) {
            fromCodePoint = Character.toCodePoint((char)prevSiblingValue, (char)fromCodePoint);
            errorStart -= prevSibling.getTextLength();
        }
        if (!Character.isSupplementaryCodePoint(toCodePoint) && Character.isHighSurrogate((char)toCodePoint) && (nextSibling = range.getNextSibling()) instanceof RegExpChar && !Character.isSupplementaryCodePoint(nextSiblingValue = ((RegExpChar)nextSibling).getValue()) && Character.isLowSurrogate((char)nextSiblingValue)) {
            toCodePoint = Character.toCodePoint((char)toCodePoint, (char)nextSiblingValue);
            errorEnd += nextSibling.getTextLength();
        }
        if (toCodePoint < fromCodePoint) {
            this.myHolder.createErrorAnnotation(new TextRange(errorStart, errorEnd), "Illegal character range (to < from)");
        } else if (toCodePoint == fromCodePoint) {
            this.myHolder.createWarningAnnotation(new TextRange(errorStart, errorEnd), "Redundant character range");
        }
    }

    @Override
    public void visitRegExpBoundary(RegExpBoundary boundary) {
        if (!this.myLanguageHosts.supportsBoundary(boundary)) {
            this.myHolder.createErrorAnnotation((PsiElement)boundary, "Unsupported boundary");
        }
    }

    @Override
    public void visitSimpleClass(RegExpSimpleClass simpleClass) {
        if (!this.myLanguageHosts.supportsSimpleClass(simpleClass)) {
            this.myHolder.createErrorAnnotation((PsiElement)simpleClass, "Illegal/unsupported escape sequence");
        }
    }

    @Override
    public void visitRegExpClass(RegExpClass regExpClass) {
        if (!(regExpClass.getParent() instanceof RegExpClass)) {
            this.checkForDuplicates(regExpClass, new HashSet<Object>());
        }
    }

    private void checkForDuplicates(RegExpClassElement element, Set<Object> seen) {
        if (element instanceof RegExpChar) {
            RegExpChar regExpChar = (RegExpChar)element;
            int value2 = regExpChar.getValue();
            if (value2 != -1 && !seen.add(value2)) {
                this.myHolder.createWarningAnnotation((PsiElement)regExpChar, "Duplicate character '" + regExpChar.getText() + "' inside character class");
            }
        } else if (element instanceof RegExpSimpleClass) {
            RegExpSimpleClass regExpSimpleClass = (RegExpSimpleClass)element;
            RegExpSimpleClass.Kind kind = regExpSimpleClass.getKind();
            if (!seen.add((Object)kind)) {
                this.myHolder.createWarningAnnotation((PsiElement)regExpSimpleClass, "Duplicate predefined character class '" + regExpSimpleClass.getText() + "' inside character class");
            }
        } else if (element instanceof RegExpClass) {
            RegExpClass regExpClass = (RegExpClass)element;
            for (RegExpClassElement classElement : regExpClass.getElements()) {
                this.checkForDuplicates(classElement, seen);
            }
        }
    }

    @Override
    public void visitRegExpChar(RegExpChar ch) {
        RegExpChar.Type charType;
        ASTNode astNode;
        PsiElement child = ch.getFirstChild();
        IElementType type = child.getNode().getElementType();
        if (type == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) {
            this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal/unsupported escape sequence");
            return;
        }
        if (type == RegExpTT.BAD_HEX_VALUE) {
            this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal hexadecimal escape sequence");
            return;
        }
        if (type == RegExpTT.BAD_OCT_VALUE) {
            this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal octal escape sequence");
            return;
        }
        if (type == StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN) {
            this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal unicode escape sequence");
            return;
        }
        String text2 = ch.getUnescapedText();
        if (type == RegExpTT.ESC_CTRL_CHARACTER && text2.equals("\\b") && !this.myLanguageHosts.supportsLiteralBackspace(ch)) {
            this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal/unsupported escape sequence");
        }
        if (text2.startsWith("\\") && this.myLanguageHosts.isRedundantEscape(ch, text2) && (astNode = ch.getNode().getFirstChildNode()) != null && astNode.getElementType() == RegExpTT.REDUNDANT_ESCAPE) {
            Annotation a = this.myHolder.createWeakWarningAnnotation((PsiElement)ch, "Redundant character escape");
            RegExpAnnotator.registerFix(a, new RemoveRedundantEscapeAction(ch));
        }
        if ((charType = ch.getType()) == RegExpChar.Type.HEX || charType == RegExpChar.Type.UNICODE) {
            if (ch.getValue() == -1) {
                this.myHolder.createErrorAnnotation((PsiElement)ch, "Illegal unicode escape sequence");
                return;
            }
            if (text2.charAt(text2.length() - 1) == '}' && !this.myLanguageHosts.supportsExtendedHexCharacter(ch)) {
                this.myHolder.createErrorAnnotation((PsiElement)ch, "This hex character syntax is not supported");
            }
        }
    }

    @Override
    public void visitRegExpProperty(RegExpProperty property) {
        ASTNode category = property.getCategoryNode();
        if (category == null) {
            return;
        }
        if (!this.myLanguageHosts.isValidCategory(category.getPsi(), category.getText())) {
            Annotation a = this.myHolder.createErrorAnnotation(category, "Unknown character category");
            a.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    @Override
    public void visitRegExpNamedCharacter(RegExpNamedCharacter namedCharacter) {
        ASTNode node;
        if (!this.myLanguageHosts.supportsNamedCharacters(namedCharacter)) {
            this.myHolder.createErrorAnnotation((PsiElement)namedCharacter, "Named Unicode characters are not allowed in this regular expression dialect");
        } else if (!this.myLanguageHosts.isValidNamedCharacter(namedCharacter) && (node = namedCharacter.getNameNode()) != null) {
            Annotation a = this.myHolder.createErrorAnnotation(node, "Unknown character name");
            a.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    @Override
    public void visitRegExpBackref(RegExpBackref backref) {
        RegExpGroup group = backref.resolve();
        if (group == null) {
            Annotation a = this.myHolder.createErrorAnnotation((PsiElement)backref, "Unresolved back reference");
            a.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        } else if (PsiTreeUtil.isAncestor((PsiElement)group, (PsiElement)backref, (boolean)true)) {
            this.myHolder.createWarningAnnotation((PsiElement)backref, "Back reference is nested into the capturing group it refers to");
        }
    }

    @Override
    public void visitRegExpGroup(RegExpGroup group) {
        RegExpGroup.Type groupType;
        ASTNode node;
        String name;
        RegExpPattern pattern = group.getPattern();
        if (pattern != null) {
            RegExpGroup.Type type;
            RegExpAtom[] atoms;
            RegExpBranch[] branches = pattern.getBranches();
            if (RegExpAnnotator.isEmpty(branches)) {
                this.myHolder.createWarningAnnotation((PsiElement)group, "Empty group");
            } else if (branches.length == 1 && (atoms = branches[0].getAtoms()).length == 1 && atoms[0] instanceof RegExpGroup && ((type = group.getType()) == RegExpGroup.Type.CAPTURING_GROUP || type == RegExpGroup.Type.ATOMIC || type == RegExpGroup.Type.NON_CAPTURING)) {
                RegExpGroup innerGroup = (RegExpGroup)atoms[0];
                if (group.isCapturing() == innerGroup.isCapturing()) {
                    this.myHolder.createWarningAnnotation((PsiElement)group, "Redundant group nesting");
                }
            }
        }
        if (group.isAnyNamedGroup() && !this.myLanguageHosts.supportsNamedGroupSyntax(group)) {
            this.myHolder.createErrorAnnotation((PsiElement)group, "This named group syntax is not supported");
        }
        if (group.getType() == RegExpGroup.Type.ATOMIC && !this.myLanguageHosts.supportsPossessiveQuantifiers(group)) {
            this.myHolder.createErrorAnnotation((PsiElement)group, "Atomic groups are not supported in this regex dialect");
        }
        if ((name = group.getName()) != null && !this.myLanguageHosts.isValidGroupName(name, group) && (node = group.getNode().findChildByType(RegExpTT.NAME)) != null) {
            this.myHolder.createErrorAnnotation(node, "Invalid group name");
        }
        if ((groupType = group.getType()) == RegExpGroup.Type.POSITIVE_LOOKBEHIND || groupType == RegExpGroup.Type.NEGATIVE_LOOKBEHIND) {
            RegExpLanguageHost.Lookbehind support = this.myLanguageHosts.supportsLookbehind(group);
            if (support == RegExpLanguageHost.Lookbehind.NOT_SUPPORTED) {
                this.myHolder.createErrorAnnotation((PsiElement)group, "Look-behind groups not supported in this regex dialect");
            } else {
                group.accept(new LookbehindVisitor(support, this.myHolder));
            }
        }
    }

    @Override
    public void visitRegExpNamedGroupRef(RegExpNamedGroupRef groupRef) {
        if (!this.myLanguageHosts.supportsNamedGroupRefSyntax(groupRef)) {
            this.myHolder.createErrorAnnotation((PsiElement)groupRef, "This named group reference syntax is not supported");
            return;
        }
        if (groupRef.getGroupName() == null) {
            return;
        }
        RegExpGroup group = groupRef.resolve();
        if (group == null) {
            ASTNode node = groupRef.getNode().findChildByType(RegExpTT.NAME);
            if (node != null) {
                Annotation a = this.myHolder.createErrorAnnotation(node, "Unresolved named group reference");
                a.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            }
        } else if (PsiTreeUtil.isAncestor((PsiElement)group, (PsiElement)groupRef, (boolean)true)) {
            this.myHolder.createWarningAnnotation((PsiElement)groupRef, "Group reference is nested into the named group it refers to");
        }
    }

    public void visitComment(PsiComment comment) {
        if (comment.getText().startsWith("(?#") && !this.myLanguageHosts.supportsPerl5EmbeddedComments(comment)) {
            this.myHolder.createErrorAnnotation((PsiElement)comment, "Embedded comments are not supported");
        }
    }

    @Override
    public void visitRegExpPyCondRef(RegExpPyCondRef condRef) {
        if (!this.myLanguageHosts.supportsPythonConditionalRefs(condRef)) {
            this.myHolder.createErrorAnnotation((PsiElement)condRef, "Conditional references are not supported");
        }
    }

    private static boolean isEmpty(RegExpBranch[] branches) {
        for (RegExpBranch branch : branches) {
            if (branch.getAtoms().length <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visitRegExpClosure(RegExpClosure closure) {
        if (closure.getAtom() instanceof RegExpSetOptions) {
            this.myHolder.createErrorAnnotation((PsiElement)closure.getQuantifier(), "Dangling metacharacter");
        }
    }

    @Override
    public void visitRegExpQuantifier(RegExpQuantifier quantifier) {
        if (quantifier.isCounted()) {
            Annotation a;
            String max;
            RegExpNumber minElement = quantifier.getMin();
            String min = minElement == null ? "" : minElement.getText();
            RegExpNumber maxElement = quantifier.getMax();
            String string2 = max = maxElement == null ? "" : maxElement.getText();
            if (!max.isEmpty() && max.equals(min)) {
                if ("1".equals(max)) {
                    a = this.myHolder.createWeakWarningAnnotation((PsiElement)quantifier, "Single repetition");
                    RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, null));
                } else {
                    ASTNode node = quantifier.getNode();
                    if (node.findChildByType(RegExpTT.COMMA) != null) {
                        Annotation a2 = this.myHolder.createWeakWarningAnnotation((PsiElement)quantifier, "Fixed repetition range");
                        RegExpAnnotator.registerFix(a2, new SimplifyQuantifierAction(quantifier, "{" + max + "}"));
                    }
                }
            } else if (("0".equals(min) || min.isEmpty()) && "1".equals(max)) {
                a = this.myHolder.createWeakWarningAnnotation((PsiElement)quantifier, "Repetition range replaceable by '?'");
                RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, "?"));
            } else if (("0".equals(min) || min.isEmpty()) && max.isEmpty()) {
                a = this.myHolder.createWeakWarningAnnotation((PsiElement)quantifier, "Repetition range replaceable by '*'");
                RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, "*"));
            } else if ("1".equals(min) && max.isEmpty()) {
                a = this.myHolder.createWeakWarningAnnotation((PsiElement)quantifier, "Repetition range replaceable by '+'");
                RegExpAnnotator.registerFix(a, new SimplifyQuantifierAction(quantifier, "+"));
            }
            Number minValue = null;
            if (minElement != null && (minValue = this.myLanguageHosts.getQuantifierValue(minElement)) == null) {
                this.myHolder.createErrorAnnotation((PsiElement)minElement, "Repetition value too large");
            }
            Number maxValue = null;
            if (maxElement != null && (maxValue = this.myLanguageHosts.getQuantifierValue(maxElement)) == null) {
                this.myHolder.createErrorAnnotation((PsiElement)maxElement, "Repetition value too large");
            }
            if (minValue != null && maxValue != null && (minValue.longValue() > maxValue.longValue() || minValue.doubleValue() > maxValue.doubleValue())) {
                TextRange range = new TextRange(minElement.getTextOffset(), maxElement.getTextOffset() + maxElement.getTextLength());
                this.myHolder.createErrorAnnotation(range, "Illegal repetition range (min > max)");
            }
        }
        if (quantifier.isPossessive() && !this.myLanguageHosts.supportsPossessiveQuantifiers(quantifier)) {
            ASTNode modifier = quantifier.getModifier();
            assert (modifier != null);
            this.myHolder.createErrorAnnotation(modifier, "Nested quantifier in regexp");
        }
    }

    @Override
    public void visitPosixBracketExpression(RegExpPosixBracketExpression posixBracketExpression) {
        ASTNode node;
        String className = posixBracketExpression.getClassName();
        if (!POSIX_CHARACTER_CLASSES.contains(className) && (node = posixBracketExpression.getNode().findChildByType(RegExpTT.NAME)) != null) {
            Annotation annotation = this.myHolder.createErrorAnnotation(node, "Unknown POSIX character class");
            annotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    private static void registerFix(Annotation a, IntentionAction action2) {
        if (a != null) {
            a.registerFix(action2);
        }
    }

    private static class LookbehindVisitor
    extends RegExpRecursiveElementVisitor {
        private final RegExpLanguageHost.Lookbehind mySupport;
        private final AnnotationHolder myHolder;
        private int myLength = 0;
        private boolean myStop = false;

        LookbehindVisitor(RegExpLanguageHost.Lookbehind support, AnnotationHolder holder) {
            this.mySupport = support;
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpElement(RegExpElement element) {
            if (this.myStop) {
                return;
            }
            super.visitRegExpElement(element);
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            super.visitRegExpChar(ch);
            ++this.myLength;
        }

        @Override
        public void visitSimpleClass(RegExpSimpleClass simpleClass) {
            super.visitSimpleClass(simpleClass);
            ++this.myLength;
        }

        @Override
        public void visitRegExpClass(RegExpClass expClass) {
            super.visitRegExpClass(expClass);
            ++this.myLength;
        }

        @Override
        public void visitRegExpProperty(RegExpProperty property) {
            super.visitRegExpProperty(property);
            ++this.myLength;
        }

        @Override
        public void visitRegExpBackref(RegExpBackref backref) {
            super.visitRegExpBackref(backref);
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FULL) {
                this.stopAndReportError(backref, "Group reference not allowed inside lookbehind");
            }
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            RegExpBranch[] branches;
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FIXED_LENGTH_ALTERNATION) {
                super.visitRegExpPattern(pattern);
                return;
            }
            int length = this.myLength;
            int branchLength = -1;
            for (RegExpBranch branch : branches = pattern.getBranches()) {
                this.myLength = 0;
                super.visitRegExpBranch(branch);
                if (branchLength == -1) {
                    branchLength = this.myLength;
                    continue;
                }
                if (branchLength == this.myLength) continue;
                this.stopAndReportError(pattern, "Alternation alternatives needs to have the same length inside lookbehind");
                return;
            }
            this.myLength = length;
        }

        @Override
        public void visitRegExpQuantifier(RegExpQuantifier quantifier) {
            super.visitRegExpQuantifier(quantifier);
            if (this.mySupport == RegExpLanguageHost.Lookbehind.FULL) {
                return;
            }
            if (quantifier.isCounted()) {
                RegExpNumber minElement = quantifier.getMin();
                RegExpNumber maxElement = quantifier.getMax();
                if (minElement != null && maxElement != null) {
                    try {
                        long min = Long.parseLong(minElement.getText());
                        long max = Long.parseLong(maxElement.getText());
                        if (min == max) {
                            this.myLength = (int)((long)this.myLength + min);
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.mySupport != RegExpLanguageHost.Lookbehind.FINITE_REPETITION) {
                    this.stopAndReportError(quantifier, "Unequal min and max in counted quantifier not allowed inside lookbehind");
                }
            } else {
                ASTNode token = quantifier.getToken();
                assert (token != null);
                String tokenText = token.getText();
                if ("?".equals(tokenText) && this.mySupport == RegExpLanguageHost.Lookbehind.FINITE_REPETITION) {
                    return;
                }
                this.stopAndReportError(quantifier, tokenText + " repetition not allowed inside lookbehind");
            }
        }

        @Override
        public void visitRegExpBoundary(RegExpBoundary boundary) {
            super.visitRegExpBoundary(boundary);
        }

        @Override
        public void visitRegExpNamedGroupRef(RegExpNamedGroupRef groupRef) {
            super.visitRegExpNamedGroupRef(groupRef);
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FULL) {
                this.stopAndReportError(groupRef, "Named group reference not allowed inside lookbehind");
            }
        }

        @Override
        public void visitRegExpPyCondRef(RegExpPyCondRef condRef) {
            super.visitRegExpPyCondRef(condRef);
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FULL) {
                this.stopAndReportError(condRef, "Conditional group reference not allowed inside lookbehind");
            }
        }

        @Override
        public void visitPosixBracketExpression(RegExpPosixBracketExpression posixBracketExpression) {
            super.visitPosixBracketExpression(posixBracketExpression);
            ++this.myLength;
        }

        public void stopAndReportError(RegExpElement element, String message2) {
            this.myHolder.createErrorAnnotation((PsiElement)element, message2);
            this.myStop = true;
        }
    }
}

