/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlStringUtil;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

class RemoveRedundantEscapeAction
implements IntentionAction {
    private final RegExpChar myChar;

    RemoveRedundantEscapeAction(@NotNull RegExpChar ch) {
        if (ch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ch", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "<init>"));
        }
        this.myChar = ch;
    }

    @NotNull
    public String getText() {
        if ("Remove redundant escape" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "getText"));
        }
        return "Remove redundant escape";
    }

    @NotNull
    public String getFamilyName() {
        if ("Redundant character escape" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "getFamilyName"));
        }
        return "Redundant character escape";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "isAvailable"));
        }
        return this.myChar.isValid() && this.myChar.getUnescapedText().startsWith("\\");
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "invoke"));
        }
        int v2 = this.myChar.getValue();
        assert (v2 != -1);
        ASTNode node = this.myChar.getNode().getFirstChildNode();
        ASTNode parent = node.getTreeParent();
        parent.addLeaf(RegExpTT.CHARACTER, (CharSequence)this.replacement(v2), node);
        parent.removeChild(node);
    }

    @NotNull
    private String replacement(int codePoint) {
        String s2;
        PsiElement context2 = this.myChar.getContainingFile().getContext();
        String string2 = s2 = Character.isSupplementaryCodePoint(codePoint) ? Character.toString(Character.highSurrogate(codePoint)) + Character.toString(Character.lowSurrogate(codePoint)) : Character.toString((char)codePoint);
        if (RegExpElementImpl.isLiteralExpression(context2)) {
            String string3 = StringUtil.escapeStringCharacters((String)s2);
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "replacement"));
            }
            return string3;
        }
        if (context2 instanceof XmlElement) {
            String string4 = XmlStringUtil.escapeString((String)s2);
            if (string4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "replacement"));
            }
            return string4;
        }
        String string5 = s2;
        if (string5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction", "replacement"));
        }
        return string5;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

