/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashSet;
import java.util.List;
import org.intellij.plugins.relaxNG.model.descriptors.CompositeDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.RngElementDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.RngXmlAttributeDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DElementPattern;

public class RngDocumentationProvider
implements DocumentationProvider {
    private static final Logger LOG = Logger.getInstance(RngDocumentationProvider.class);
    @NonNls
    private static final String COMPATIBILITY_ANNOTATIONS_1_0 = "http://relaxng.org/ns/compatibility/annotations/1.0";

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        XmlElement c2 = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)originalElement, (Class[])new Class[]{XmlTag.class, XmlAttribute.class});
        if (c2 != null && c2.getManager() == null) {
            LOG.warn("Invalid context element passed to generateDoc()", new Throwable("<stack trace>"));
            return null;
        }
        if (c2 instanceof XmlTag) {
            RngElementDescriptor d2;
            PsiElement declaration;
            XmlTag xmlElement = (XmlTag)c2;
            XmlElementDescriptor descriptor2 = xmlElement.getDescriptor();
            if (descriptor2 instanceof CompositeDescriptor) {
                StringBuilder sb2 = new StringBuilder();
                CompositeDescriptor d3 = (CompositeDescriptor)descriptor2;
                DElementPattern[] patterns = d3.getElementPatterns();
                THashSet elements = ContainerUtil.newIdentityTroveSet();
                for (DElementPattern pattern : patterns) {
                    PsiElement psiElement = d3.getDeclaration(pattern.getLocation());
                    if (!(psiElement instanceof XmlTag) || !elements.add((Object)psiElement)) continue;
                    if (sb2.length() > 0) {
                        sb2.append("<hr>");
                    }
                    sb2.append((CharSequence)RngDocumentationProvider.getDocumentationFromTag((XmlTag)psiElement, xmlElement.getLocalName(), "Element"));
                }
                return RngDocumentationProvider.makeDocumentation(sb2);
            }
            if (descriptor2 instanceof RngElementDescriptor && (declaration = (d2 = (RngElementDescriptor)descriptor2).getDeclaration()) instanceof XmlTag) {
                return RngDocumentationProvider.makeDocumentation(RngDocumentationProvider.getDocumentationFromTag((XmlTag)declaration, xmlElement.getLocalName(), "Element"));
            }
        } else if (c2 instanceof XmlAttribute) {
            XmlAttribute attribute = (XmlAttribute)c2;
            XmlAttributeDescriptor descriptor3 = attribute.getDescriptor();
            if (descriptor3 instanceof RngXmlAttributeDescriptor) {
                RngXmlAttributeDescriptor d4 = (RngXmlAttributeDescriptor)descriptor3;
                StringBuilder sb3 = new StringBuilder();
                THashSet declaration = ContainerUtil.newIdentityTroveSet(d4.getDeclarations());
                for (PsiElement psiElement : declaration) {
                    if (!(psiElement instanceof XmlTag)) continue;
                    if (sb3.length() > 0) {
                        sb3.append("<hr>");
                    }
                    sb3.append((CharSequence)RngDocumentationProvider.getDocumentationFromTag((XmlTag)psiElement, d4.getName(), "Attribute"));
                }
                return RngDocumentationProvider.makeDocumentation(sb3);
            }
        } else if (element instanceof XmlTag) {
            return RngDocumentationProvider.makeDocumentation(RngDocumentationProvider.getDocumentationFromTag((XmlTag)element, ((XmlTag)element).getLocalName(), "Element"));
        }
        return null;
    }

    private static String makeDocumentation(StringBuilder sb2) {
        if (sb2 == null) {
            return null;
        }
        String s2 = sb2.toString().replaceAll("\n", "<br>");
        if (!s2.startsWith("<html>")) {
            s2 = XmlStringUtil.wrapInHtml((CharSequence)s2);
        }
        return s2;
    }

    private static StringBuilder getDocumentationFromTag(XmlTag tag, String localName, String kind) {
        if (tag.getNamespace().equals("http://relaxng.org/ns/structure/1.0")) {
            XmlTag[] docTags;
            StringBuilder sb2 = new StringBuilder();
            sb2.append(kind).append(": <b>").append(localName).append("</b><br>");
            for (XmlTag docTag : docTags = tag.findSubTags("documentation", COMPATIBILITY_ANNOTATIONS_1_0)) {
                sb2.append(docTag.getValue().getTrimmedText());
                sb2.append("\n");
            }
            XmlTag nextTag = (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, XmlTag.class);
            if (nextTag != null && "documentation".equals(nextTag.getLocalName()) && COMPATIBILITY_ANNOTATIONS_1_0.equals(nextTag.getNamespace())) {
                sb2.append(nextTag.getValue().getTrimmedText());
            }
            return sb2;
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context2) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    public int hashCode() {
        return 0;
    }
}

