/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDecl;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.jetbrains.annotations.NotNull;

public class RncCompletionContributor
extends CompletionContributor {
    private static final ElementPattern TOP_LEVEL = StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(RncGrammar.class).inside(true, (ElementPattern)PlatformPatterns.psiElement(RncGrammar.class))));
    private static final PsiElementPattern DECL_PATTERN = (PsiElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(RncDecl.class));
    private static final PsiElementPattern DEFAULT_PATTERN = DECL_PATTERN.afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("default"));
    private static final ElementPattern DEFINE_PATTERN = StandardPatterns.and((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withParent(RncDefine.class), PlatformPatterns.psiElement().afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PlatformPatterns.psiElement().withText("="))});
    private static final String[] DECL_KEYWORDS = new String[]{"default", "namespace", "datatypes"};
    private static final String[] GRAMMAR_CONTENT_KEYWORDS = new String[]{"include", "div", "start"};
    private static final String[] PATTERN_KEYWORDS = new String[]{"attribute", "element", "grammar", "notAllowed", "text", "empty", "external", "parent", "list", "mixed"};

    public RncCompletionContributor() {
        CompletionProvider<CompletionParameters> provider = new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context2, @NotNull CompletionResultSet result2) {
                String[] keywords;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/intellij/plugins/relaxNG/compact/RncCompletionContributor$1", "addCompletions"));
                }
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/plugins/relaxNG/compact/RncCompletionContributor$1", "addCompletions"));
                }
                for (String keyword : keywords = RncCompletionContributor.getKeywords(parameters.getPosition())) {
                    result2.addElement(TailTypeDecorator.withTail(LookupElementBuilder.create((String)keyword).bold(), TailType.SPACE));
                }
            }
        };
        this.extend(null, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)RncTokenTypes.KEYWORD_DEFAULT)), (CompletionProvider)provider);
        this.extend(null, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().andNot((ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement((IElementType)RncTokenTypes.LITERAL)))).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(RncTokenTypes.KEYWORDS))), (CompletionProvider)provider);
    }

    private static String[] getKeywords(PsiElement context2) {
        PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)context2, (Class[])new Class[]{PsiWhiteSpace.class});
        if (next != null && EscapeUtil.unescapeText(next).equals("=")) {
            return new String[]{"start"};
        }
        if (DEFAULT_PATTERN.accepts((Object)context2)) {
            return new String[]{"namespace"};
        }
        if (DECL_PATTERN.accepts((Object)context2)) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (context2.getParent() instanceof RncDefine && context2.getParent().getFirstChild() == context2) {
            if (DEFINE_PATTERN.accepts((Object)context2)) {
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            if (TOP_LEVEL.accepts((Object)context2) && !RncCompletionContributor.afterPattern(context2)) {
                return ArrayUtil.mergeArrays((String[])DECL_KEYWORDS, (String[])ArrayUtil.mergeArrays((String[])GRAMMAR_CONTENT_KEYWORDS, (String[])PATTERN_KEYWORDS));
            }
            return GRAMMAR_CONTENT_KEYWORDS;
        }
        return PATTERN_KEYWORDS;
    }

    private static boolean afterPattern(PsiElement context2) {
        return PsiTreeUtil.getPrevSiblingOfType((PsiElement)context2.getParent(), RncDefine.class) != null;
    }
}

