/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.lexer;

import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.kohsuke.rngom.util.Utf16;

class EscapePreprocessor
extends FilterReader {
    private final TIntArrayList myQueuedChars;
    private final TIntIntHashMap myLengthMap;
    private int myOffset;

    public EscapePreprocessor(Reader reader, int startOffset, TIntIntHashMap map2) {
        super(reader);
        this.myOffset = startOffset;
        this.myQueuedChars = new TIntArrayList();
        this.myLengthMap = map2;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i2 = this.read();
        if (i2 == -1) {
            return -1;
        }
        cbuf[off] = (char)i2;
        return 1;
    }

    @Override
    public int read() throws IOException {
        if (this.myQueuedChars.size() > 0) {
            return this.consume();
        }
        int i2 = super.read();
        if (i2 == -1) {
            return -1;
        }
        ++this.myOffset;
        switch (i2) {
            case 13: {
                assert (false) : "Unexpected newline character";
                if (this.peek() == 10) {
                    this.consume();
                    this.myLengthMap.put(this.myOffset - 1, 2);
                }
            }
            case 10: {
                return 0;
            }
            case 92: {
                int x2;
                int n2 = 0;
                while ((x2 = this.peek()) == 120) {
                    ++n2;
                }
                if (n2 > 0 && x2 == 123) {
                    ++n2;
                } else {
                    return i2;
                }
                int value2 = 0;
                while (EscapePreprocessor.isHexChar((char)(x2 = this.peek()))) {
                    ++n2;
                    value2 <<= 4;
                    value2 |= Character.digit(x2, 16);
                }
                if (x2 == 125) {
                    ++n2;
                }
                this.consume(n2);
                this.myLengthMap.put(this.myOffset - 1, n2);
                this.myOffset += n2;
                if (value2 <= 65535) {
                    return value2;
                }
                this.myQueuedChars.add((int)Utf16.surrogate2((int)value2));
                return Utf16.surrogate1((int)value2);
            }
        }
        return i2;
    }

    private static boolean isHexChar(char i2) {
        if (Character.isDigit(i2)) {
            return true;
        }
        char c2 = Character.toLowerCase(i2);
        return c2 >= 'a' && c2 <= 'f';
    }

    private int consume() {
        if (this.myQueuedChars.size() > 0) {
            ++this.myOffset;
            return this.myQueuedChars.remove(0);
        }
        return -1;
    }

    private void consume(int n2) {
        this.myQueuedChars.remove(0, n2);
    }

    private int peek() throws IOException {
        int i2 = super.read();
        if (i2 == -1) {
            return -1;
        }
        this.myQueuedChars.add(i2);
        return i2;
    }
}

