/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.parser.AbstractParsing;

public abstract class DeclarationParsing
extends AbstractParsing {
    public DeclarationParsing(PsiBuilder builder) {
        super(builder);
    }

    protected void parseTopLevel() {
        while (!this.myBuilder.eof() && LA_DECL.contains(this.currentToken())) {
            this.parseDecl(this.myBuilder);
        }
        if (LA_GRAMMAR_CONTENT.contains(this.currentToken())) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            this.parseGrammarContents();
            marker.done(RncElementTypes.GRAMMAR_PATTERN);
        } else if (this.currentToken() == RncTokenTypes.KEYWORD_GRAMMAR) {
            this.parsePattern();
        } else {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            while (!this.myBuilder.eof() && this.parsePattern()) {
            }
            marker.done(RncElementTypes.GRAMMAR_PATTERN);
        }
    }

    protected abstract boolean parsePattern();

    protected void parseGrammarContents() {
        while (LA_GRAMMAR_CONTENT.contains(this.currentToken())) {
            this.parseGrammarContent(true);
        }
    }

    private void parseIncludeContents() {
        while (LA_INCLUDE_CONTENT.contains(this.currentToken())) {
            this.parseGrammarContent(false);
        }
    }

    private void parseGrammarContent(boolean allowInclude) {
        IElementType t2 = this.currentToken();
        if (t2 == RncTokenTypes.KEYWORD_START) {
            this.parseStart();
        } else if (t2 == RncTokenTypes.KEYWORD_DIV) {
            this.parseDiv();
        } else if (allowInclude && t2 == RncTokenTypes.KEYWORD_INCLUDE) {
            this.parseInclude();
        } else if (RncTokenTypes.IDENTIFIERS.contains(t2)) {
            this.parseDefine();
        } else {
            this.error("Unexpected token");
            this.advance();
        }
    }

    private void parseDefine() {
        PsiBuilder.Marker marker = this.begin();
        this.match(ASSIGN_METHOD, "'=', '|=' or '&=' expected");
        if (!this.parsePattern()) {
            this.error("Pattern expected");
        }
        marker.done(RncElementTypes.DEFINE);
    }

    private void parseInclude() {
        PsiBuilder.Marker marker = this.begin();
        this.parseAnyUriLiteral();
        this.parseInherit();
        if (this.matches(RncTokenTypes.LBRACE)) {
            this.parseIncludeContents();
            this.match(RncTokenTypes.RBRACE, "'}' expected");
        }
        marker.done(RncElementTypes.INCLUDE);
    }

    protected final void parseAnyUriLiteral() {
        this.match(RncTokenTypes.LITERAL, "URI literal expected");
    }

    protected final void parseInherit() {
        if (this.matches(RncTokenTypes.KEYWORD_INHERIT)) {
            this.match(RncTokenTypes.EQ, "'=' expected");
            this.match(RncTokenTypes.IDENTIFIER_OR_KEYWORD, "Identifier expected");
        }
    }

    private void parseDiv() {
        PsiBuilder.Marker marker = this.begin();
        this.parseBracedGrammarContents();
        marker.done(RncElementTypes.DIV);
    }

    private void parseStart() {
        PsiBuilder.Marker marker = this.begin();
        this.match(ASSIGN_METHOD, "'=', '|=' or '&=' expected");
        if (!this.parsePattern()) {
            this.error("Pattern expected");
        }
        marker.done(RncElementTypes.START);
    }

    protected void parseBracedGrammarContents() {
        this.match(RncTokenTypes.LBRACE, "'{' expected");
        this.parseGrammarContents();
        this.match(RncTokenTypes.RBRACE, "'}' expected");
    }

    protected void parseDecl(PsiBuilder builder) {
        IElementType t2 = builder.getTokenType();
        if (t2 == RncTokenTypes.KEYWORD_NAMESPACE) {
            this.parseNamespaceDecl(false);
        } else if (t2 == RncTokenTypes.KEYWORD_DEFAULT) {
            this.parseNamespaceDecl(true);
        } else if (t2 == RncTokenTypes.KEYWORD_DATATYPES) {
            this.parseDataTypesDecl();
        }
    }

    private void parseDataTypesDecl() {
        PsiBuilder.Marker marker = this.begin();
        this.match(RncTokenTypes.IDENTIFIER_OR_KEYWORD, "Identifier expected");
        this.match(RncTokenTypes.EQ, "'=' expected");
        this.parseNsUriLiteral();
        marker.done(RncElementTypes.DATATYPES_DECL);
    }

    private void parseNamespaceDecl(boolean isDefault) {
        PsiBuilder.Marker marker = this.begin();
        if (isDefault) {
            this.match(RncTokenTypes.KEYWORD_NAMESPACE, "'namespace' expected");
            this.matches(RncTokenTypes.IDENTIFIER_OR_KEYWORD);
        } else {
            this.match(RncTokenTypes.IDENTIFIER_OR_KEYWORD, "Identifier expected");
        }
        this.match(RncTokenTypes.EQ, "'=' expected");
        this.parseNsUriLiteral();
        marker.done(RncElementTypes.NS_DECL);
    }

    private void parseNsUriLiteral() {
        this.match(NS_URI_LITERAL, "Namespace URI or 'inherit' expected");
    }
}

