/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.parser.AbstractParsing;

public class NameClassParsing
extends AbstractParsing {
    public NameClassParsing(PsiBuilder builder) {
        super(builder);
    }

    public boolean parseNameClass() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.parseNameClassPart()) {
            marker.drop();
            return false;
        }
        if (this.currentToken() == RncTokenTypes.PIPE) {
            do {
                this.advance();
                if (this.parseNameClassPart()) continue;
                this.error("NameClass expected");
            } while (this.currentToken() == RncTokenTypes.PIPE);
            marker.done(RncElementTypes.NAME_CLASS_CHOICE);
        } else {
            marker.drop();
        }
        return true;
    }

    private boolean parseNameClassPart() {
        IElementType t2 = this.currentToken();
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (RncTokenTypes.IDENTIFIER_OR_KEYWORD.contains(t2)) {
            this.advance();
        } else if (RncTokenTypes.PREFIXED_NAME == t2) {
            this.makeName();
        } else if (RncTokenTypes.STAR == t2) {
            this.advance();
            this.parseExceptNameClass();
        } else if (RncTokenTypes.PREFIXED_STAR == t2) {
            this.makeName();
            this.parseExceptNameClass();
        } else if (RncTokenTypes.LPAREN == t2) {
            this.advance();
            if (this.parseNameClass()) {
                this.match(RncTokenTypes.RPAREN, "')' expected");
            }
        } else {
            marker.drop();
            return false;
        }
        marker.done(RncElementTypes.NAME_CLASS);
        return true;
    }

    private void parseExceptNameClass() {
        if (RncTokenTypes.MINUS == this.currentToken()) {
            PsiBuilder.Marker marker = this.begin();
            if (!this.parseNameClass()) {
                this.error("NameClass expected");
            }
            marker.done(RncElementTypes.EXCEPT_NAME_CLASS);
        }
    }
}

