/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDecl;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncElementImpl;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RncDeclImpl
extends RncElementImpl
implements RncDecl {
    public RncDeclImpl(ASTNode node) {
        super(node);
    }

    @Override
    public String getPrefix() {
        ASTNode ns = this.findIdentifierNode();
        return ns != null ? EscapeUtil.unescapeText(ns) : null;
    }

    @Override
    public String getDeclaredNamespace() {
        ASTNode ns = this.getNode().findChildByType(RncTokenTypes.LITERAL);
        return ns != null ? EscapeUtil.parseLiteralValue(ns) : null;
    }

    @Override
    public int getTextOffset() {
        ASTNode ns = this.findIdentifierNode();
        if (ns != null) {
            return ns.getStartOffset();
        }
        return super.getTextOffset();
    }

    private ASTNode findIdentifierNode() {
        ASTNode[] nodes;
        ASTNode node = this.getNode().findChildByType(RncTokenTypes.IDENTIFIERS);
        if (node == null && (nodes = this.getNode().getChildren(RncTokenTypes.KEYWORDS)).length > 1) {
            return nodes[1];
        }
        return node;
    }

    @Override
    public String getName() {
        String s2 = this.getPrefix();
        return s2 != null ? s2 : "";
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/intellij/plugins/relaxNG/compact/psi/impl/RncDeclImpl", "setName"));
        }
        ASTNode node = this.findIdentifierNode();
        if (node == null) {
            return this;
        }
        node.getTreeParent().replaceChild(node, RenameUtil.createIdentifierNode(this.getManager(), name));
        return this;
    }

    @Override
    public void accept(@NotNull RncElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/intellij/plugins/relaxNG/compact/psi/impl/RncDeclImpl", "accept"));
        }
        visitor2.visitElement(this);
    }
}

