/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.xml.util.XmlUtil;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncFileReference;
import org.intellij.plugins.relaxNG.compact.psi.impl.FollowFileHint;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncElementImpl;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.references.FileReferenceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class RncFileReferenceImpl
extends RncElementImpl
implements RncFileReference {
    public RncFileReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        ASTNode literal = this.getNode().findChildByType(RncTokenTypes.LITERAL);
        if (literal == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileReferenceImpl", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String s2 = literal.getText();
        FileReferenceSet set2 = new FileReferenceSet(s2.substring(1, s2.length() - 1), this, this.getReferenceRange().getStartOffset(), null, true, false);
        PsiReference[] psiReferenceArray = FileReferenceUtil.restrict(set2, FileReferenceUtil.byType(RncFileType.getInstance()));
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileReferenceImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public RncFile getReferencedFile() {
        PsiFile file2;
        String href = this.getFileReference();
        if (href != null && (file2 = XmlUtil.findRelativeFile(href, (PsiElement)this.getContainingFile())) instanceof RncFile) {
            return (RncFile)file2;
        }
        return null;
    }

    @Override
    @Nullable
    public String getFileReference() {
        ASTNode element = this.getNode().findChildByType(RncTokenTypes.LITERAL);
        if (element == null) {
            return null;
        }
        String s2 = EscapeUtil.unescapeText(element);
        return s2.substring(1, s2.length() - 1);
    }

    @Override
    public TextRange getReferenceRange() {
        ASTNode literal = this.getNode().findChildByType(RncTokenTypes.LITERAL);
        if (literal == null) {
            return TextRange.from((int)0, (int)0);
        }
        int startInElement = literal.getStartOffset() - this.getTextOffset() + 1;
        return TextRange.from((int)startInElement, (int)(literal.getTextLength() - 2));
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileReferenceImpl", "processDeclarations"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileReferenceImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileReferenceImpl", "processDeclarations"));
        }
        FollowFileHint hint = (FollowFileHint)processor2.getHint(FollowFileHint.KEY);
        RncFile file2 = this.getReferencedFile();
        if (file2 != null && hint != null && hint.doFollow(file2)) {
            file2.processDeclarations(processor2, substitutor, lastParent, place);
        }
        return true;
    }
}

