/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDecl;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.RncName;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncElementImpl;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RncNameImpl
extends RncElementImpl
implements RncName,
PsiReference,
EmptyResolveMessageProvider,
LocalQuickFixProvider {
    public RncNameImpl(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public String getPrefix() {
        String[] parts = EscapeUtil.unescapeText(this.getNode()).split(":", 2);
        return parts.length == 2 ? parts[0] : null;
    }

    @Override
    @NotNull
    public String getLocalPart() {
        String[] parts = EscapeUtil.unescapeText(this.getNode()).split(":", 2);
        String string2 = parts.length == 1 ? parts[0] : parts[1];
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl", "getLocalPart"));
        }
        return string2;
    }

    @Override
    public void accept(@NotNull RncElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl", "accept"));
        }
        visitor2.visitName(this);
    }

    @Override
    public PsiReference getReference() {
        return this.getPrefix() == null ? null : this;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        return TextRange.from((int)0, (int)this.getText().indexOf(58));
    }

    @Nullable
    public PsiElement resolve() {
        MyResolver resolver = new MyResolver(this.getPrefix(), this.getKind());
        this.getContainingFile().processDeclarations((PsiScopeProcessor)resolver, ResolveState.initial(), (PsiElement)this, (PsiElement)this);
        return resolver.getResult();
    }

    private Kind getKind() {
        IElementType parent = this.getNode().getTreeParent().getElementType();
        if (parent == RncElementTypes.DATATYPE_PATTERN) {
            return Kind.DATATYPES;
        }
        return Kind.NAMESPACE;
    }

    @NotNull
    public String getCanonicalText() {
        String string2 = this.getRangeInElement().substring(this.getText());
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl", "getCanonicalText"));
        }
        return string2;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ASTNode node = this.getNode();
        ASTNode child = RenameUtil.createPrefixedNode(this.getManager(), newElementName, this.getLocalPart());
        node.getTreeParent().replaceChild(node, child);
        return child.getPsi();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl", "bindToElement"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof RncElement && Comparing.equal((Object)this.resolve(), (Object)element);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        String prefix = this.getPrefix();
        return "xsd".equals(prefix) || "xml".equals(prefix);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        if ("Unresolved namespace prefix ''{0}''" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl", "getUnresolvedMessagePattern"));
        }
        return "Unresolved namespace prefix ''{0}''";
    }

    @Nullable
    public LocalQuickFix[] getQuickFixes() {
        if (this.getPrefix() != null) {
            return new LocalQuickFix[]{new CreateDeclFix(this)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    public static class CreateDeclFix
    implements LocalQuickFix {
        private final RncNameImpl myReference;

        public CreateDeclFix(RncNameImpl reference) {
            this.myReference = reference;
        }

        @NotNull
        public String getName() {
            String string2 = this.getFamilyName() + " '" + this.myReference.getPrefix() + "'";
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl$CreateDeclFix", "getName"));
            }
            return string2;
        }

        @NotNull
        public String getFamilyName() {
            String string2 = "Create " + this.myReference.getKind().name().toLowerCase() + " declaration";
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl$CreateDeclFix", "getFamilyName"));
            }
            return string2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Editor editor;
            RncGrammar rncGrammar;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl$CreateDeclFix", "applyFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl$CreateDeclFix", "applyFix"));
            }
            String prefix = this.myReference.getPrefix();
            PsiFileFactory factory2 = PsiFileFactory.getInstance((Project)this.myReference.getProject());
            RncFile psiFile = (RncFile)factory2.createFileFromText("dummy.rnc", RncFileType.getInstance(), (CharSequence)(this.myReference.getKind().name().toLowerCase() + " " + prefix + " = \"###\""));
            RncFile rncFile = (RncFile)this.myReference.getContainingFile();
            RncDecl[] declarations = rncFile.getDeclarations();
            RncDecl decl = psiFile.getDeclarations()[0];
            RncDecl e2 = declarations.length > 0 ? (RncDecl)rncFile.addAfter(decl, declarations[declarations.length - 1]) : ((rncGrammar = rncFile.getGrammar()) != null ? (RncDecl)rncFile.addBefore(decl, rncGrammar) : (RncDecl)rncFile.add(decl));
            ASTNode blockNode = e2.getParent().getNode();
            assert (blockNode != null);
            ASTNode newNode = e2.getNode();
            assert (newNode != null);
            CodeStyleManager.getInstance((Project)e2.getManager().getProject()).reformatNewlyAddedElement(blockNode, newNode);
            PsiElement literal = e2.getLastChild();
            assert (literal != null);
            ASTNode literalNode = literal.getNode();
            assert (literalNode != null);
            assert (literalNode.getElementType() == RncTokenTypes.LITERAL);
            int offset = literal.getTextRange().getStartOffset();
            literal.delete();
            VirtualFile virtualFile = this.myReference.getElement().getContainingFile().getVirtualFile();
            if (virtualFile != null && (editor = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, virtualFile, offset), true)) != null) {
                RncDecl rncDecl = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(e2);
                TemplateManager manager = TemplateManager.getInstance(project2);
                Template t2 = manager.createTemplate("", "");
                t2.addTextSegment(" \"");
                Expression expression = new Expression(){

                    public Result calculateResult(ExpressionContext context2) {
                        return new TextResult("");
                    }

                    public Result calculateQuickResult(ExpressionContext context2) {
                        return this.calculateResult(context2);
                    }

                    public LookupItem[] calculateLookupItems(ExpressionContext context2) {
                        return LookupItem.EMPTY_ARRAY;
                    }
                };
                t2.addVariable("uri", expression, expression, true);
                t2.addTextSegment("\"");
                t2.addEndVariable();
                editor.getCaretModel().moveToOffset(rncDecl.getTextRange().getEndOffset());
                manager.startTemplate(editor, t2);
            }
        }
    }

    private static class MyResolver
    extends BaseScopeProcessor {
        private final String myPrefix;
        private final Kind myKind;
        private PsiElement myResult;

        public MyResolver(String prefix, Kind kind) {
            this.myPrefix = prefix;
            this.myKind = kind;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState substitutor) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl$MyResolver", "execute"));
            }
            if (substitutor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl$MyResolver", "execute"));
            }
            ASTNode node = element.getNode();
            if (node == null) {
                return true;
            }
            if (!(element instanceof RncDecl)) {
                return false;
            }
            IElementType type = node.getElementType();
            return !(this.myKind == Kind.NAMESPACE && type == RncElementTypes.NS_DECL ? this.checkDecl(element) : this.myKind == Kind.DATATYPES && type == RncElementTypes.DATATYPES_DECL && this.checkDecl(element));
        }

        private boolean checkDecl(PsiElement element) {
            if (this.myPrefix.equals(((RncDecl)element).getPrefix())) {
                this.myResult = element;
                return true;
            }
            return false;
        }

        public PsiElement getResult() {
            return this.myResult;
        }
    }

    private static enum Kind {
        NAMESPACE,
        DATATYPES;

    }
}

