/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.jetbrains.annotations.NotNull;

public class EscapeUtil {
    public static String unescapeText(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/compact/psi/util/EscapeUtil", "unescapeText"));
        }
        ASTNode node = element.getNode();
        if (node != null) {
            return EscapeUtil.unescapeText(node);
        }
        return element.getText();
    }

    public static String unescapeText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/relaxNG/compact/psi/util/EscapeUtil", "unescapeText"));
        }
        String text2 = node.getText();
        if (node.getElementType() == RncTokenTypes.ESCAPED_IDENTIFIER) {
            assert (text2.charAt(0) == '\\');
            return text2.length() > 1 ? text2.substring(1) : "";
        }
        return text2;
    }

    public static String parseLiteralValue(ASTNode ns) {
        return EscapeUtil.unquote(EscapeUtil.unescapeText(ns));
    }

    private static String unquote(String s2) {
        if (s2.length() >= 6 && s2.charAt(0) == s2.charAt(1)) {
            s2 = s2.replace('\u0000', '\n');
            return s2.substring(3, s2.length() - 3);
        }
        return s2.substring(1, s2.length() - 1);
    }
}

