/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.config;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlSchemaProvider;
import org.intellij.plugins.relaxNG.config.NoNamespaceConfig;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NoNamespaceSchemaProvider
extends XmlSchemaProvider {
    @Nullable
    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module2, @NotNull PsiFile baseFile) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/intellij/plugins/relaxNG/config/NoNamespaceSchemaProvider", "getSchema"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "org/intellij/plugins/relaxNG/config/NoNamespaceSchemaProvider", "getSchema"));
        }
        if ("".equals(url)) {
            Project project2 = baseFile.getProject();
            VirtualFile file2 = NoNamespaceConfig.getInstance(project2).getMappedFile(baseFile);
            if (file2 == null) {
                return null;
            }
            PsiFile f2 = PsiManager.getInstance((Project)project2).findFile(file2);
            if (f2 instanceof XmlFile) {
                return (XmlFile)f2;
            }
        }
        return null;
    }

    public boolean isAvailable(@NotNull XmlFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/config/NoNamespaceSchemaProvider", "isAvailable"));
        }
        if (file2.getFileType() != XmlFileType.INSTANCE) {
            return false;
        }
        NoNamespaceConfig config = NoNamespaceConfig.getInstance(file2.getProject());
        return config != null && config.getMappedFile((PsiFile)file2) != null;
    }
}

