/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.convert;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaDialog;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaSettings;
import org.intellij.plugins.relaxNG.convert.IdeaDriver;
import org.intellij.plugins.relaxNG.convert.IdeaErrorHandler;
import org.intellij.plugins.relaxNG.convert.SchemaType;
import org.intellij.plugins.relaxNG.validation.ValidateAction;

public class ConvertSchemaAction
extends AnAction {
    public void update(AnActionEvent e2) {
        VirtualFile[] files2 = (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        if (files2 != null && project2 != null) {
            SchemaType type = ConvertSchemaAction.getInputType(project2, files2);
            e2.getPresentation().setEnabled(type != null);
            if (type == SchemaType.XML) {
                e2.getPresentation().setText("Generate Schema from XML file" + (files2.length > 1 ? "s" : "") + "...");
            } else {
                e2.getPresentation().setText("Convert Schema...");
            }
        } else {
            e2.getPresentation().setEnabled(false);
        }
    }

    private static SchemaType getInputType(Project project2, VirtualFile ... files2) {
        if (files2.length == 0) {
            return null;
        }
        VirtualFile file2 = files2[0];
        FileType type = file2.getFileType();
        if (type == StdFileTypes.XML) {
            XmlDocument document;
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
            if (psiFile instanceof XmlFile && (document = ((XmlFile)psiFile).getDocument()) != null && document.getRootTag() != null) {
                XmlTag rootTag = document.getRootTag();
                assert (rootTag != null);
                String uri2 = rootTag.getNamespace();
                if ("http://relaxng.org/ns/structure/1.0".equals(uri2) && files2.length == 1) {
                    return SchemaType.RNG;
                }
            }
            if (files2.length > 1) {
                for (VirtualFile virtualFile : files2) {
                    if (virtualFile.getFileType() == StdFileTypes.XML && ConvertSchemaAction.getInputType(project2, virtualFile) == null) continue;
                    return null;
                }
            }
            return SchemaType.XML;
        }
        if (type == StdFileTypes.DTD && files2.length == 1) {
            return SchemaType.DTD;
        }
        if (type == RncFileType.getInstance() && files2.length == 1) {
            return SchemaType.RNC;
        }
        return null;
    }

    public void actionPerformed(AnActionEvent e2) {
        VirtualFile file2 = (VirtualFile)e2.getData(CommonDataKeys.VIRTUAL_FILE);
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        if (file2 != null && project2 != null) {
            VirtualFile[] files2 = (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            assert (files2 != null);
            SchemaType type = ConvertSchemaAction.getInputType(project2, files2);
            ConvertSchemaDialog dialog2 = new ConvertSchemaDialog(project2, type, file2);
            if (!dialog2.showAndGet()) {
                return;
            }
            ValidateAction.saveFiles(files2);
            ConvertSchemaSettings settings = dialog2.getSettings();
            IdeaErrorHandler errorHandler = new IdeaErrorHandler(project2);
            new IdeaDriver(settings, project2).convert(type, errorHandler, files2);
            VirtualFile output = LocalFileSystem.getInstance().findFileByIoFile(new File(settings.getOutputDestination()));
            if (output != null) {
                output.refresh(false, true);
            }
        }
    }
}

