/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.annotation;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.annotation.OverriddenDefineSearcher;
import org.intellij.plugins.relaxNG.model.annotation.OverridingDefineRenderer;
import org.intellij.plugins.relaxNG.model.resolve.GrammarFactory;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OverriddenDefineRenderer
extends GutterIconRenderer
implements DumbAware {
    private final Define myDefine;

    public OverriddenDefineRenderer(@NotNull Define define2) {
        if (define2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "define", "org/intellij/plugins/relaxNG/model/annotation/OverriddenDefineRenderer", "<init>"));
        }
        this.myDefine = define2;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Gutter.OverridenMethod;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/model/annotation/OverriddenDefineRenderer", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e2) {
                Object element = OverriddenDefineRenderer.this.myDefine.getPsiElement();
                if (element == null || !element.isValid()) {
                    return;
                }
                PsiElementProcessor.CollectElements collector = new PsiElementProcessor.CollectElements();
                XmlFile localFile = (XmlFile)element.getContainingFile();
                RelaxIncludeIndex.processBackwardDependencies(localFile, (PsiElementProcessor<XmlFile>)collector);
                Collection files2 = collector.getCollection();
                SmartList result2 = new SmartList();
                OverriddenDefineSearcher searcher = new OverriddenDefineSearcher(OverriddenDefineRenderer.this.myDefine, localFile, (List<Define>)result2);
                for (XmlFile file2 : files2) {
                    Grammar grammar = GrammarFactory.getGrammar(file2);
                    if (grammar == null) continue;
                    grammar.acceptChildren(searcher);
                }
                if (result2.size() > 0) {
                    OverridingDefineRenderer.doClickAction(e2, (Collection<Define>)result2, "Go to overriding define(s)");
                }
            }
        };
    }

    public boolean isNavigateAction() {
        return true;
    }

    @Nullable
    public String getTooltipText() {
        return "Is overridden";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
            return false;
        }
        OverriddenDefineRenderer that = (OverriddenDefineRenderer)((Object)o2);
        return this.myDefine.equals(that.myDefine);
    }

    public int hashCode() {
        return this.myDefine.hashCode();
    }
}

