/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.openapi.util.Pair;
import gnu.trove.THashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.model.descriptors.RecursionSaveWalker;
import org.kohsuke.rngom.digested.DAttributePattern;
import org.kohsuke.rngom.digested.DChoicePattern;
import org.kohsuke.rngom.digested.DDataPattern;
import org.kohsuke.rngom.digested.DElementPattern;
import org.kohsuke.rngom.digested.DOptionalPattern;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.digested.DValuePattern;
import org.kohsuke.rngom.digested.DZeroOrMorePattern;

class AttributeFinder
extends RecursionSaveWalker {
    private int depth;
    private int optional;
    private final QName myQname;
    private final Map<DAttributePattern, Pair<? extends Map<String, String>, Boolean>> myAttributes = new THashMap();
    private DAttributePattern myLastAttr;

    private AttributeFinder() {
        this.myQname = null;
        ++this.optional;
    }

    private AttributeFinder(QName qname) {
        this.myQname = qname;
    }

    public Void onElement(DElementPattern p2) {
        ++this.depth;
        try {
            this.myLastAttr = null;
            if (this.depth < 2) {
                Void void_ = super.onElement(p2);
                return void_;
            }
            Void void_ = null;
            return void_;
        }
        finally {
            --this.depth;
        }
    }

    public Void onAttribute(DAttributePattern p2) {
        assert (this.depth > 0);
        if (this.depth == 1 && (this.myQname == null || p2.getName().contains(this.myQname))) {
            this.myLastAttr = p2;
            if (!this.myAttributes.containsKey(p2)) {
                this.myAttributes.put(p2, (Pair<? extends Map<String, String>, Boolean>)Pair.create(new LinkedHashMap(), (Object)(this.optional > 0 ? 1 : 0)));
            }
            return super.onAttribute(p2);
        }
        return null;
    }

    public Void onValue(DValuePattern p2) {
        if (this.myLastAttr != null) {
            ((Map)this.myAttributes.get((Object)this.myLastAttr).first).put(p2.getValue(), p2.getType());
        }
        return super.onValue(p2);
    }

    public Void onOptional(DOptionalPattern p2) {
        ++this.optional;
        try {
            Void void_ = super.onOptional(p2);
            return void_;
        }
        finally {
            --this.optional;
        }
    }

    public Void onZeroOrMore(DZeroOrMorePattern p2) {
        ++this.optional;
        try {
            Void void_ = super.onZeroOrMore(p2);
            return void_;
        }
        finally {
            --this.optional;
        }
    }

    public Void onChoice(DChoicePattern p2) {
        ++this.optional;
        try {
            Void void_ = super.onChoice(p2);
            return void_;
        }
        finally {
            --this.optional;
        }
    }

    public Void onData(DDataPattern p2) {
        if (this.depth == 1 && this.myLastAttr != null) {
            ((Map)this.myAttributes.get((Object)this.myLastAttr).first).put(null, p2.getType());
        }
        return null;
    }

    public static Map<DAttributePattern, Pair<? extends Map<String, String>, Boolean>> find(QName qname, DPattern ... patterns) {
        AttributeFinder finder = new AttributeFinder(qname);
        finder.doAccept(patterns);
        return finder.myAttributes;
    }

    public static Map<DAttributePattern, Pair<? extends Map<String, String>, Boolean>> find(DPattern ... patterns) {
        AttributeFinder finder = new AttributeFinder();
        finder.doAccept(patterns);
        return finder.myAttributes;
    }
}

