/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.model.descriptors.AttributeFinder;
import org.intellij.plugins.relaxNG.model.descriptors.ChildElementFinder;
import org.intellij.plugins.relaxNG.model.descriptors.RngElementDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.RngNsDescriptor;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DElementPattern;
import org.kohsuke.rngom.digested.DPattern;

public class CompositeDescriptor
extends RngElementDescriptor {
    private final DElementPattern[] myPatterns;

    CompositeDescriptor(RngNsDescriptor nsDescriptor, DElementPattern pattern, List<DElementPattern> patterns) {
        super(nsDescriptor, pattern);
        this.myPatterns = patterns.toArray(new DElementPattern[patterns.size()]);
    }

    @Override
    protected XmlElementDescriptor findElementDescriptor(XmlTag childTag) {
        ArrayList<DElementPattern> patterns = new ArrayList<DElementPattern>();
        for (DElementPattern pattern : this.myPatterns) {
            patterns.addAll(ChildElementFinder.find(2, (DPattern)pattern));
        }
        XmlElementDescriptor d2 = this.myNsDescriptor.findDescriptor(childTag, patterns);
        if (d2 != null) {
            return d2;
        }
        return NULL;
    }

    @Override
    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context2) {
        ArrayList<XmlElementDescriptor> descriptors = new ArrayList<XmlElementDescriptor>(Arrays.asList(super.getElementsDescriptors(context2)));
        for (DElementPattern pattern : this.myPatterns) {
            List<DElementPattern> list2 = ChildElementFinder.find(2, (DPattern)pattern);
            descriptors.addAll(Arrays.asList(this.myNsDescriptor.convertElementDescriptors(list2)));
        }
        return descriptors.toArray(new XmlElementDescriptor[descriptors.size()]);
    }

    @Override
    protected XmlAttributeDescriptor getAttributeDescriptor(String namespace, String localName) {
        QName qname = new QName(namespace, localName);
        return this.computeAttributeDescriptor(AttributeFinder.find(qname, (DPattern[])this.myPatterns));
    }

    @Override
    protected XmlAttributeDescriptor[] collectAttributeDescriptors(@Nullable XmlTag context2) {
        DElementPattern[] patterns;
        QName qName = null;
        if (qName == null) {
            patterns = this.myPatterns;
        } else {
            List p2 = ContainerUtil.findAll((Object[])this.myPatterns, pattern -> pattern.getName().contains(qName));
            patterns = p2.toArray(new DPattern[p2.size()]);
        }
        return this.computeAttributeDescriptors(AttributeFinder.find((DPattern[])patterns));
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        CompositeDescriptor that = (CompositeDescriptor)o2;
        return Arrays.equals(this.myPatterns, that.myPatterns);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.myPatterns);
        return result2;
    }

    public DElementPattern[] getElementPatterns() {
        return this.myPatterns;
    }
}

