/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.model.descriptors.AttributeFinder;
import org.intellij.plugins.relaxNG.model.descriptors.ChildElementFinder;
import org.intellij.plugins.relaxNG.model.descriptors.RngNsDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.RngXmlAttributeDescriptor;
import org.intellij.plugins.relaxNG.validation.RngSchemaValidator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DAttributePattern;
import org.kohsuke.rngom.digested.DElementPattern;
import org.kohsuke.rngom.digested.DEmptyPattern;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.digested.DTextPattern;
import org.kohsuke.rngom.nc.NameClass;
import org.kohsuke.rngom.nc.NameClassVisitor;
import org.xml.sax.Locator;

public class RngElementDescriptor
implements XmlElementDescriptor {
    private static final Key<ParameterizedCachedValue<XmlElementDescriptor, RngElementDescriptor>> DESCR_KEY = Key.create((String)"DESCR");
    private static final Key<ParameterizedCachedValue<XmlAttributeDescriptor[], RngElementDescriptor>> ATTRS_KEY = Key.create((String)"ATTRS");
    protected static final XmlElementDescriptor NULL = null;
    private final DElementPattern myElementPattern;
    protected final RngNsDescriptor myNsDescriptor;
    private volatile SmartPsiElementPointer<? extends PsiElement> myDeclaration;

    RngElementDescriptor(RngNsDescriptor nsDescriptor, DElementPattern pattern) {
        this.myNsDescriptor = nsDescriptor;
        this.myElementPattern = pattern;
    }

    public String getQualifiedName() {
        QName qName = this.getQName();
        return qName != null ? RngElementDescriptor.format(qName, "") : "#unknown";
    }

    public String getDefaultName() {
        return this.getName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context2) {
        DElementPattern p2;
        if (context2 == null) {
            return EMPTY_ARRAY;
        }
        XmlElementDescriptor descriptor2 = this.myNsDescriptor.getElementDescriptor(context2);
        DElementPattern pattern = descriptor2 instanceof RngElementDescriptor ? ((p2 = ((RngElementDescriptor)descriptor2).myElementPattern) != null ? p2 : this.myElementPattern) : this.myElementPattern;
        List<DElementPattern> patterns = ChildElementFinder.find(2, (DPattern)pattern);
        return this.myNsDescriptor.convertElementDescriptors(patterns);
    }

    protected XmlElementDescriptor findElementDescriptor(XmlTag childTag) {
        List<DElementPattern> patterns = ChildElementFinder.find(2, (DPattern)this.myElementPattern);
        XmlElementDescriptor d2 = this.myNsDescriptor.findDescriptor(childTag, patterns);
        return d2 == null ? NULL : d2;
    }

    public final XmlElementDescriptor getElementDescriptor(XmlTag childTag) {
        return this.getElementDescriptor(childTag, null);
    }

    public final XmlElementDescriptor getElementDescriptor(final XmlTag childTag, XmlTag contextTag) {
        XmlElementDescriptor value2 = RngElementDescriptor.getCachedValue(childTag, this, DESCR_KEY, new ParameterizedCachedValueProvider<XmlElementDescriptor, RngElementDescriptor>(){

            public CachedValueProvider.Result<XmlElementDescriptor> compute(RngElementDescriptor p2) {
                XmlElementDescriptor descriptor2 = p2.findElementDescriptor(childTag);
                return CachedValueProvider.Result.create((Object)descriptor2, (Object[])new Object[]{p2.getDependences(), childTag});
            }
        });
        return value2 == NULL ? null : value2;
    }

    public final XmlAttributeDescriptor[] getAttributesDescriptors(final @Nullable XmlTag context2) {
        if (context2 != null) {
            return RngElementDescriptor.getCachedValue(context2, this, ATTRS_KEY, new ParameterizedCachedValueProvider<XmlAttributeDescriptor[], RngElementDescriptor>(){

                public CachedValueProvider.Result<XmlAttributeDescriptor[]> compute(RngElementDescriptor p2) {
                    XmlAttributeDescriptor[] value2 = p2.collectAttributeDescriptors(context2);
                    return CachedValueProvider.Result.create((Object)value2, (Object[])new Object[]{p2.getDependences(), context2});
                }
            });
        }
        return this.collectAttributeDescriptors(null);
    }

    private static <D extends PsiElement, T, P> T getCachedValue(D context2, P p2, Key<ParameterizedCachedValue<T, P>> key, ParameterizedCachedValueProvider<T, P> provider) {
        CachedValuesManager mgr = CachedValuesManager.getManager((Project)context2.getProject());
        return (T)mgr.getParameterizedCachedValue(context2, key, provider, false, p2);
    }

    protected XmlAttributeDescriptor[] collectAttributeDescriptors(@Nullable XmlTag context2) {
        return this.computeAttributeDescriptors(AttributeFinder.find((QName)null, new DPattern[]{this.myElementPattern}));
    }

    protected XmlAttributeDescriptor[] computeAttributeDescriptors(Map<DAttributePattern, Pair<? extends Map<String, String>, Boolean>> map2) {
        HashMap name2descriptor = new HashMap();
        for (DAttributePattern pattern : map2.keySet()) {
            Pair<? extends Map<String, String>, Boolean> value2 = map2.get(pattern);
            for (QName name : pattern.getName().listNames()) {
                RngXmlAttributeDescriptor descriptor2 = (RngXmlAttributeDescriptor)name2descriptor.get(name);
                RngXmlAttributeDescriptor newDescriptor = new RngXmlAttributeDescriptor(this, pattern, (Map)value2.first, (Boolean)value2.second);
                descriptor2 = descriptor2 == null ? newDescriptor : descriptor2.mergeWith(newDescriptor);
                name2descriptor.put(name, descriptor2);
            }
        }
        Collection result2 = name2descriptor.values();
        return result2.toArray(new RngXmlAttributeDescriptor[result2.size()]);
    }

    public final XmlAttributeDescriptor getAttributeDescriptor(String attributeName, @Nullable XmlTag context2) {
        return this.getAttributeDescriptor("", attributeName);
    }

    public final XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getNamespace(), attribute.getLocalName());
    }

    protected XmlAttributeDescriptor getAttributeDescriptor(String namespace, String localName) {
        QName qname = new QName(namespace, localName);
        return this.computeAttributeDescriptor(AttributeFinder.find(qname, new DPattern[]{this.myElementPattern}));
    }

    protected XmlAttributeDescriptor computeAttributeDescriptor(Map<DAttributePattern, Pair<? extends Map<String, String>, Boolean>> attributes) {
        if (attributes.size() > 0) {
            RngXmlAttributeDescriptor d2 = null;
            Set<DAttributePattern> patterns = attributes.keySet();
            for (DAttributePattern pattern : patterns) {
                Pair<? extends Map<String, String>, Boolean> pair = attributes.get(pattern);
                RngXmlAttributeDescriptor a = new RngXmlAttributeDescriptor(this, pattern, (Map)pair.first, (Boolean)pair.second);
                if (d2 == null) {
                    d2 = a;
                    continue;
                }
                d2 = d2.mergeWith(a);
            }
            return d2;
        }
        return null;
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myNsDescriptor;
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        DPattern child = this.myElementPattern.getChild();
        if (child instanceof DEmptyPattern) {
            return 0;
        }
        if (child instanceof DTextPattern) {
            return 3;
        }
        if (child instanceof DElementPattern) {
            return (Integer)((DElementPattern)child).getName().accept((NameClassVisitor)MyNameClassVisitor.INSTANCE);
        }
        return 2;
    }

    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        PsiElement element;
        SmartPsiElementPointer<? extends PsiElement> declaration = this.myDeclaration;
        if (declaration != null && (element = declaration.getElement()) != null && element.isValid()) {
            return element;
        }
        PsiElement decl = this.myNsDescriptor.getDeclaration();
        if (decl == null) {
            this.myDeclaration = null;
            return null;
        }
        PsiElement element2 = RngElementDescriptor.getDeclarationImpl(decl, this.myElementPattern.getLocation());
        if (element2 != null && element2 != decl) {
            this.myDeclaration = SmartPointerManager.getInstance((Project)decl.getProject()).createSmartPsiElementPointer(element2);
        }
        return element2;
    }

    public PsiElement getDeclaration(Locator location) {
        PsiElement element = this.myNsDescriptor.getDeclaration();
        if (element == null) {
            return null;
        }
        return RngElementDescriptor.getDeclarationImpl(element, location);
    }

    private static PsiElement getDeclarationImpl(PsiElement decl, Locator location) {
        PsiElement at;
        VirtualFile virtualFile = RngSchemaValidator.findVirtualFile(location.getSystemId());
        if (virtualFile == null) {
            return decl;
        }
        Project project2 = decl.getProject();
        PsiFile file2 = PsiManager.getInstance((Project)project2).findFile(virtualFile);
        if (file2 == null) {
            return decl;
        }
        int column = location.getColumnNumber();
        int line = location.getLineNumber();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        assert (document != null);
        if (line <= 0 || document.getLineCount() < line - 1) {
            return decl;
        }
        int startOffset = document.getLineStartOffset(line - 1);
        if (column > 0) {
            if (decl.getContainingFile().getFileType() == RncFileType.getInstance()) {
                PsiElement rncElement = file2.findElementAt(startOffset + column);
                ASTNode pattern = rncElement != null ? TreeUtil.findParent(rncElement.getNode(), RncElementTypes.PATTERN) : null;
                ASTNode nameClass = pattern != null ? pattern.findChildByType(RncElementTypes.NAME_CLASS) : null;
                return nameClass != null ? nameClass.getPsi() : rncElement;
            }
            at = file2.findElementAt(startOffset + column - 2);
        } else {
            PsiElement element = file2.findElementAt(startOffset);
            at = element != null ? PsiTreeUtil.nextLeaf((PsiElement)element) : null;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)at, XmlTag.class);
    }

    @NonNls
    public String getName(PsiElement context2) {
        QName qName = this.getQName();
        if (qName == null) {
            return "#unknown";
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlTag.class, (boolean)false);
        String prefix = xmlTag != null ? xmlTag.getPrefixByNamespace(qName.getNamespaceURI()) : null;
        return RngElementDescriptor.format(qName, prefix != null ? prefix : qName.getPrefix());
    }

    @NonNls
    public String getName() {
        QName qName = this.getQName();
        if (qName == null) {
            return "#unknown";
        }
        return qName.getLocalPart();
    }

    private static String format(QName qName, String p2) {
        String localPart = qName.getLocalPart();
        return p2.length() > 0 ? p2 + ":" + localPart : localPart;
    }

    @Nullable
    private QName getQName() {
        Iterator iterator2 = this.myElementPattern.getName().listNames().iterator();
        if (!iterator2.hasNext()) {
            return null;
        }
        return (QName)iterator2.next();
    }

    public void init(PsiElement element) {
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        RngElementDescriptor that = (RngElementDescriptor)o2;
        return this.myElementPattern.equals(that.myElementPattern);
    }

    public int hashCode() {
        return this.myElementPattern.hashCode();
    }

    public Object[] getDependences() {
        if (this.myDeclaration != null) {
            return ArrayUtil.append((Object[])this.myNsDescriptor.getDependences(), (Object)this.myDeclaration.getElement());
        }
        return this.myNsDescriptor.getDependences();
    }

    public DElementPattern getElementPattern() {
        return this.myElementPattern;
    }

    private static class MyNameClassVisitor
    implements NameClassVisitor<Integer> {
        public static final MyNameClassVisitor INSTANCE = new MyNameClassVisitor();

        private MyNameClassVisitor() {
        }

        public Integer visitAnyName() {
            return 1;
        }

        public Integer visitAnyNameExcept(NameClass nc2) {
            return 1;
        }

        public Integer visitChoice(NameClass nc1, NameClass nc2) {
            return 2;
        }

        public Integer visitName(QName name) {
            return 2;
        }

        public Integer visitNsName(String ns) {
            return 2;
        }

        public Integer visitNsNameExcept(String ns, NameClass nc2) {
            return 2;
        }

        public Integer visitNull() {
            return 0;
        }
    }
}

