/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptorEx;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.model.descriptors.ChildElementFinder;
import org.intellij.plugins.relaxNG.model.descriptors.CompositeDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.NamedPatternFilter;
import org.intellij.plugins.relaxNG.model.descriptors.RngElementDescriptor;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.intellij.plugins.relaxNG.validation.RngParser;
import org.intellij.plugins.relaxNG.validation.XmlInstanceValidator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DElementPattern;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.nc.NameClass;

public class RngNsDescriptor
implements XmlNSDescriptorEx,
Validator {
    private final Map<QName, CachedValue<XmlElementDescriptor>> myDescriptorsMap = Collections.synchronizedMap(new HashMap());
    private static final Key<ParameterizedCachedValue<XmlElementDescriptor, RngNsDescriptor>> ROOT_KEY = Key.create((String)"ROOT_DESCRIPTOR");
    private XmlFile myFile;
    private PsiElement myElement;
    private String myUrl;
    private DPattern myPattern;
    private PsiManager myManager;

    @Nullable
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        XmlElementDescriptor desc;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/plugins/relaxNG/model/descriptors/RngNsDescriptor", "getElementDescriptor"));
        }
        if (this.myPattern == null) {
            return null;
        }
        LinkedList<XmlTag> chain = new LinkedList<XmlTag>();
        for (XmlTag _tag = tag; _tag != null; _tag = _tag.getParentTag()) {
            chain.addFirst(_tag);
        }
        while ((desc = this.findRootDescriptor((XmlTag)chain.removeFirst())) == null && chain.size() > 0) {
        }
        if (desc != null) {
            XmlTag xmlTag;
            Iterator iterator2 = chain.iterator();
            while (iterator2.hasNext() && (desc = desc.getElementDescriptor(xmlTag = (XmlTag)iterator2.next(), xmlTag.getParentTag())) != null) {
            }
        }
        if (desc == null || desc instanceof AnyXmlElementDescriptor) {
            return this.findRootDescriptor(tag);
        }
        return desc;
    }

    private XmlElementDescriptor findRootDescriptor(final XmlTag tag) {
        return (XmlElementDescriptor)CachedValuesManager.getManager((Project)tag.getProject()).getParameterizedCachedValue((UserDataHolder)tag, ROOT_KEY, (ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<XmlElementDescriptor, RngNsDescriptor>(){

            public CachedValueProvider.Result<XmlElementDescriptor> compute(RngNsDescriptor o2) {
                XmlElementDescriptor descr = o2.findRootDescriptorInner(tag);
                if (descr != null) {
                    return CachedValueProvider.Result.create((Object)descr, (Object[])new Object[]{tag, descr.getDependences(), o2.getDependences()});
                }
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{tag, o2.getDependences()});
            }
        }, false, (Object)this);
    }

    private XmlElementDescriptor findRootDescriptorInner(XmlTag tag) {
        List allNamedPatterns = ContainerUtil.findAll(ChildElementFinder.find(-1, this.myPattern), (Condition)NamedPatternFilter.INSTANCE);
        XmlElementDescriptor descriptor2 = this.findDescriptor(tag, (List<DElementPattern>)allNamedPatterns);
        return descriptor2 != null ? descriptor2 : this.findDescriptor(tag, ChildElementFinder.find(this.myPattern));
    }

    private XmlElementDescriptor findRootDescriptorInner(QName qName) {
        return this.findDescriptor(qName, (List<DElementPattern>)ContainerUtil.findAll(ChildElementFinder.find(-1, this.myPattern), (Condition)NamedPatternFilter.INSTANCE));
    }

    public XmlElementDescriptor findDescriptor(XmlTag tag, List<DElementPattern> list2) {
        QName qName = new QName(tag.getNamespace(), tag.getLocalName());
        return this.findDescriptor(qName, list2);
    }

    private XmlElementDescriptor findDescriptor(QName qName, List<DElementPattern> list2) {
        int max = -1;
        DElementPattern maxPattern = null;
        for (DElementPattern pattern2 : list2) {
            int spec;
            NameClass nameClass = pattern2.getName();
            if (!nameClass.contains(qName) || (spec = nameClass.containsSpecificity(qName)) <= max) continue;
            maxPattern = pattern2;
            max = spec;
        }
        List patterns = ContainerUtil.findAll(list2, pattern -> {
            NameClass nameClass = pattern.getName();
            return nameClass.contains(qName);
        });
        if (maxPattern != null) {
            if (patterns.size() > 1) {
                return this.initDescriptor(new CompositeDescriptor(this, maxPattern, patterns));
            }
            return this.initDescriptor(new RngElementDescriptor(this, maxPattern));
        }
        return null;
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
        if (this.myPattern == null) {
            if (XmlElementDescriptor.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/model/descriptors/RngNsDescriptor", "getRootElementsDescriptors"));
            }
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        List<DElementPattern> list2 = ChildElementFinder.find(-1, this.myPattern);
        XmlElementDescriptor[] xmlElementDescriptorArray = this.convertElementDescriptors(list2);
        if (xmlElementDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/model/descriptors/RngNsDescriptor", "getRootElementsDescriptors"));
        }
        return xmlElementDescriptorArray;
    }

    XmlElementDescriptor[] convertElementDescriptors(List<DElementPattern> patterns) {
        patterns = ContainerUtil.findAll(patterns, (Condition)NamedPatternFilter.INSTANCE);
        HashMap name2patterns = new HashMap();
        for (DElementPattern pattern : patterns) {
            for (QName qName : pattern.getName().listNames()) {
                ArrayList<DElementPattern> dPatterns = (ArrayList<DElementPattern>)name2patterns.get(qName);
                if (dPatterns == null) {
                    dPatterns = new ArrayList<DElementPattern>();
                    name2patterns.put(qName, dPatterns);
                }
                if (dPatterns.contains(pattern)) continue;
                dPatterns.add(pattern);
            }
        }
        ArrayList<XmlElementDescriptor> result2 = new ArrayList<XmlElementDescriptor>();
        for (QName qName : name2patterns.keySet()) {
            List patternList;
            XmlElementDescriptor descriptor2 = this.findDescriptor(qName, (List<DElementPattern>)(patternList = (List)name2patterns.get(qName)));
            if (descriptor2 == null) continue;
            result2.add(descriptor2);
        }
        return result2.toArray(new XmlElementDescriptor[result2.size()]);
    }

    protected XmlElementDescriptor initDescriptor(@NotNull XmlElementDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/intellij/plugins/relaxNG/model/descriptors/RngNsDescriptor", "initDescriptor"));
        }
        return descriptor2;
    }

    @NotNull
    public XmlFile getDescriptorFile() {
        XmlFile xmlFile = this.myFile;
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/model/descriptors/RngNsDescriptor", "getDescriptorFile"));
        }
        return xmlFile;
    }

    public synchronized PsiElement getDeclaration() {
        PsiFile file2;
        VirtualFile fileByUrl;
        if (!(this.myElement.isValid() && this.myFile.isValid() || this.myUrl == null || (fileByUrl = VirtualFileManager.getInstance().findFileByUrl(this.myUrl)) == null || !((file2 = this.myManager.findFile(fileByUrl)) instanceof XmlFile))) {
            this.init((PsiElement)((XmlFile)file2).getDocument());
        }
        return this.myFile.isValid() ? this.myFile.getDocument() : null;
    }

    @NonNls
    public String getName(PsiElement context2) {
        return this.getName();
    }

    @NonNls
    public String getName() {
        return this.getDescriptorFile().getName();
    }

    public Object[] getDependences() {
        if (this.myPattern != null) {
            if (DumbService.isDumb((Project)this.myElement.getProject())) {
                return new Object[]{ModificationTracker.EVER_CHANGED, ExternalResourceManager.getInstance()};
            }
            Object[] a = new Object[]{this.myElement, ExternalResourceManager.getInstance()};
            PsiElementProcessor.CollectElements processor2 = new PsiElementProcessor.CollectElements();
            RelaxIncludeIndex.processForwardDependencies(this.myFile, (PsiElementProcessor<XmlFile>)processor2);
            if (processor2.getCollection().size() > 0) {
                return ArrayUtil.mergeArrays((Object[])a, (Object[])processor2.toArray());
            }
            return a;
        }
        return new Object[]{ModificationTracker.EVER_CHANGED};
    }

    public synchronized void init(PsiElement element) {
        this.myElement = element;
        this.myFile = element instanceof XmlFile ? (XmlFile)element : (XmlFile)element.getContainingFile();
        this.myManager = this.myFile.getManager();
        VirtualFile file2 = this.myFile.getVirtualFile();
        if (file2 != null) {
            this.myUrl = file2.getUrl();
        }
        this.myPattern = RngParser.getCachedPattern((PsiFile)this.getDescriptorFile(), RngParser.DEFAULT_HANDLER);
    }

    public void validate(@NotNull PsiElement context2, @NotNull Validator.ValidationHost host) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/plugins/relaxNG/model/descriptors/RngNsDescriptor", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/intellij/plugins/relaxNG/model/descriptors/RngNsDescriptor", "validate"));
        }
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getContextOfType((PsiElement)context2, XmlDocument.class, (boolean)false);
        if (doc == null) {
            return;
        }
        XmlTag rootTag = doc.getRootTag();
        if (rootTag == null) {
            return;
        }
        if (!"http://relaxng.org/ns/structure/1.0".equals(rootTag.getNamespace())) {
            XmlInstanceValidator.doValidation(doc, host, this.getDescriptorFile());
        }
    }

    public XmlElementDescriptor getElementDescriptor(String localName, String namespace) {
        QName qName = new QName(namespace, localName);
        CachedValue cachedValue = this.myDescriptorsMap.get(qName);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)this.myElement.getProject()).createCachedValue(() -> {
                XmlElementDescriptor descriptor2 = this.findRootDescriptorInner(qName);
                return descriptor2 != null ? new CachedValueProvider.Result((Object)descriptor2, descriptor2.getDependences()) : new CachedValueProvider.Result(null, this.getDependences());
            }, false);
            this.myDescriptorsMap.put(qName, (CachedValue<XmlElementDescriptor>)cachedValue);
        }
        return (XmlElementDescriptor)cachedValue.getValue();
    }
}

