/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.references;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceUtil {
    public static PsiReference[] restrict(FileReferenceSet set2, Condition<PsiFile> cond) {
        return FileReferenceUtil.restrict(set2, cond, null);
    }

    public static PsiReference[] restrict(FileReferenceSet set2, Condition<PsiFile> cond, Boolean soft) {
        Object[] references = set2.getAllReferences();
        return (PsiReference[])ContainerUtil.map2Array((Object[])references, PsiReference.class, (Function)((NotNullFunction)fileReference -> new MyFileReference((FileReference)fileReference, cond, soft)));
    }

    public static Condition<PsiFile> byType(FileType instance2) {
        return new TypeCondition(instance2);
    }

    public static Condition<PsiFile> byNamespace(String ns) {
        return new PatternCondition((PsiFilePattern)XmlPatterns.xmlFile().withRootTag((ElementPattern)XmlPatterns.xmlTag().withNamespace((ElementPattern)XmlPatterns.string().equalTo((Object)ns))));
    }

    private static class MyFileReference
    extends FileReference {
        private final Condition<PsiFile> myCond;
        private final Boolean mySoft;

        public MyFileReference(FileReference fileReference, Condition<PsiFile> cond, @Nullable Boolean soft) {
            super(fileReference.getFileReferenceSet(), fileReference.getRangeInElement(), fileReference.getIndex(), fileReference.getCanonicalText());
            this.myCond = cond;
            this.mySoft = soft;
        }

        @Override
        public boolean isSoft() {
            return this.mySoft == null ? super.isSoft() : this.mySoft.booleanValue();
        }

        @Override
        public PsiFileSystemItem resolve() {
            PsiFileSystemItem result2 = super.resolve();
            if (result2 instanceof PsiFile && !this.myCond.value((Object)((PsiFile)result2))) {
                return null;
            }
            return result2;
        }

        @Override
        @NotNull
        public Object[] getVariants() {
            Object[] variants = super.getVariants();
            Object[] objectArray = ContainerUtil.findAll((Object[])variants, o2 -> MyFileReference.match(o2, this.myCond)).toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/references/FileReferenceUtil$MyFileReference", "getVariants"));
            }
            return objectArray;
        }

        private static boolean match(Object o2, Condition<PsiFile> cond) {
            return !(o2 instanceof PsiFileSystemItem) || ((PsiFileSystemItem)o2).isDirectory() || o2 instanceof PsiFile && cond.value((Object)((PsiFile)o2));
        }
    }

    private static class PatternCondition
    implements Condition<PsiFile> {
        private final PsiFilePattern myPattern;

        public PatternCondition(PsiFilePattern pattern) {
            this.myPattern = pattern;
        }

        public boolean value(PsiFile o2) {
            return this.myPattern.accepts((Object)o2);
        }
    }

    private static class TypeCondition
    implements Condition<PsiFile> {
        private final FileType myType;

        public TypeCondition(FileType type) {
            this.myType = type;
        }

        public boolean value(PsiFile file2) {
            return file2.getFileType() == this.myType;
        }
    }
}

