/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.validation;

import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ui.ErrorTreeView;
import gnu.trove.THashSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.swing.Icon;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MessageViewHelper {
    private static final Logger LOG = Logger.getInstance((String)"#org.intellij.plugins.relaxNG.validation.MessageViewHelper");
    private final Project myProject;
    private final Set<String> myErrors = new THashSet();
    private final String myContentName;
    private final Key<NewErrorTreeViewPanel> myKey;
    private NewErrorTreeViewPanel myErrorsView;
    private NewErrorTreeViewPanel.ProcessController myProcessController = MyProcessController.INSTANCE;

    public MessageViewHelper(Project project2, String contentName, Key<NewErrorTreeViewPanel> key) {
        this.myProject = project2;
        this.myContentName = contentName;
        this.myKey = key;
    }

    public synchronized void setProcessController(NewErrorTreeViewPanel.ProcessController processController) {
        if (this.myErrorsView == null) {
            this.myProcessController = processController;
        } else {
            this.myErrorsView.setProcessController(processController);
        }
    }

    public synchronized void openMessageView(Runnable rerun) {
        assert (this.myErrorsView == null);
        this.myErrorsView = new NewErrorTreeViewPanel(this.myProject, null, true, true, rerun);
        this.openMessageViewImpl();
    }

    public synchronized void processError(SAXParseException ex, boolean warning) {
        String error;
        if (this.myErrors.size() == 0 && this.myErrorsView == null) {
            this.myErrorsView = new NewErrorTreeViewPanel(this.myProject, null, true, true, null);
            this.myErrorsView.setProcessController(this.myProcessController);
            this.openMessageViewImpl();
        }
        if (!this.myErrors.add(error = ex.getLineNumber() + "|" + ex.getColumnNumber() + "|" + ex.getSystemId() + "|" + ex.getLocalizedMessage())) {
            return;
        }
        VirtualFile file2 = null;
        String systemId = ex.getSystemId();
        if (systemId != null) {
            try {
                file2 = VfsUtil.findFileByURL((URL)new URL(systemId));
            }
            catch (MalformedURLException e2) {
                LOG.warn("systemId = " + systemId);
                LOG.error((Throwable)e2);
            }
        }
        VirtualFile file1 = file2;
        ApplicationManager.getApplication().invokeLater(() -> this.myErrorsView.addMessage(warning ? 5 : 4, new String[]{ex.getLocalizedMessage()}, file1, ex.getLineNumber() - 1, ex.getColumnNumber() - 1, null));
    }

    public void close() {
        this.removeOldContents(null);
    }

    private void removeOldContents(Content notToRemove) {
        MessageView messageView = MessageView.SERVICE.getInstance(this.myProject);
        for (Content content2 : messageView.getContentManager().getContents()) {
            ErrorTreeView listErrorView;
            if (content2.isPinned() || !this.myContentName.equals(content2.getDisplayName()) || content2 == notToRemove || (listErrorView = (ErrorTreeView)content2.getComponent()) == null || !messageView.getContentManager().removeContent(content2, true)) continue;
            content2.release();
        }
    }

    private void openMessageViewImpl() {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            MessageView messageView = MessageView.SERVICE.getInstance(this.myProject);
            Content content2 = ContentFactory.SERVICE.getInstance().createContent(this.myErrorsView.getComponent(), this.myContentName, true);
            content2.putUserData(this.myKey, (Object)this.myErrorsView);
            messageView.getContentManager().addContent(content2);
            messageView.getContentManager().setSelectedContent(content2);
            messageView.getContentManager().addContentManagerListener((ContentManagerListener)new CloseListener(content2, this.myContentName, this.myErrorsView));
            this.removeOldContents(content2);
            messageView.getContentManager().addContentManagerListener((ContentManagerListener)new MyContentDisposer(content2, messageView, this.myKey));
        }, "Open Message View", null);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
    }

    public class ErrorHandler
    extends DefaultHandler {
        private boolean myHadErrorOrWarning;

        @Override
        public void warning(SAXParseException e2) throws SAXException {
            this.myHadErrorOrWarning = true;
            MessageViewHelper.this.processError(e2, true);
        }

        @Override
        public void error(SAXParseException e2) throws SAXException {
            this.myHadErrorOrWarning = true;
            MessageViewHelper.this.processError(e2, false);
        }

        @Override
        public void fatalError(SAXParseException e2) throws SAXException {
            this.myHadErrorOrWarning = true;
            MessageViewHelper.this.processError(e2, false);
        }

        public boolean hadErrorOrWarning() {
            return this.myHadErrorOrWarning;
        }
    }

    private static class MyContentDisposer
    extends ContentManagerAdapter {
        private final Content myContent;
        private final MessageView myMessageView;
        private final Key<NewErrorTreeViewPanel> myKey;

        MyContentDisposer(Content content2, MessageView messageView, Key<NewErrorTreeViewPanel> key) {
            this.myContent = content2;
            this.myMessageView = messageView;
            this.myKey = key;
        }

        public void contentRemoved(ContentManagerEvent event) {
            Content eventContent = event.getContent();
            if (!eventContent.equals(this.myContent)) {
                return;
            }
            this.myMessageView.getContentManager().removeContentManagerListener((ContentManagerListener)this);
            NewErrorTreeViewPanel errorTreeView = (NewErrorTreeViewPanel)eventContent.getUserData(this.myKey);
            if (errorTreeView != null) {
                errorTreeView.dispose();
            }
            eventContent.putUserData(this.myKey, null);
        }
    }

    private static class CloseListener
    extends ContentManagerAdapter {
        private final String myContentName;
        private NewErrorTreeViewPanel myErrorsView;
        private Content myContent;

        public CloseListener(Content content2, String contentName, NewErrorTreeViewPanel errorsView) {
            this.myContent = content2;
            this.myContentName = contentName;
            this.myErrorsView = errorsView;
        }

        public void contentRemoved(ContentManagerEvent event) {
            if (event.getContent() == this.myContent) {
                if (this.myErrorsView.canControlProcess()) {
                    this.myErrorsView.stopProcess();
                }
                this.myErrorsView = null;
                this.myContent.getManager().removeContentManagerListener((ContentManagerListener)this);
                this.myContent.release();
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            int result2;
            if (event.getContent() == this.myContent && this.myErrorsView != null && this.myErrorsView.canControlProcess() && !this.myErrorsView.isProcessStopped() && (result2 = Messages.showYesNoDialog((String)(this.myContentName + " Running"), (String)(this.myContentName + " is still running. Close anyway?"), (Icon)Messages.getQuestionIcon())) != 0) {
                event.consume();
            }
        }
    }

    private static class MyProcessController
    implements NewErrorTreeViewPanel.ProcessController {
        public static final MyProcessController INSTANCE = new MyProcessController();

        private MyProcessController() {
        }

        @Override
        public void stopProcess() {
        }

        @Override
        public boolean isProcessStopped() {
            return true;
        }
    }
}

