/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.validation;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import org.intellij.plugins.relaxNG.validation.Psi2SaxAdapter;
import org.intellij.plugins.relaxNG.validation.RngParser;
import org.intellij.plugins.relaxNG.validation.RngSchemaValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlInstanceValidator {
    private static final Logger LOG = Logger.getInstance((String)"org.intellij.plugins.relaxNG.validation.XmlInstanceValidator");

    private XmlInstanceValidator() {
    }

    public static void doValidation(@NotNull XmlDocument doc, Validator.ValidationHost host, XmlFile descriptorFile) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "org/intellij/plugins/relaxNG/validation/XmlInstanceValidator", "doValidation"));
        }
        try {
            Schema schema = RngParser.getCachedSchema(descriptorFile);
            if (schema == null) {
                return;
            }
            ErrorHandler eh = MyErrorHandler.create(doc, host);
            if (eh == null) {
                return;
            }
            PropertyMapBuilder builder = new PropertyMapBuilder();
            builder.put((PropertyId)ValidateProperty.ERROR_HANDLER, (Object)eh);
            ContentHandler handler2 = schema.createValidator(builder.toPropertyMap()).getContentHandler();
            doc.accept((PsiElementVisitor)new Psi2SaxAdapter(handler2));
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (RuntimeException e3) {
            LOG.error((Throwable)e3);
        }
        catch (Exception e4) {
            LOG.info((Throwable)e4);
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private final Validator.ValidationHost myHost;
        private final Document myDocument;
        private final PsiFile myFile;

        private MyErrorHandler(XmlDocument doc, Validator.ValidationHost host) {
            this.myHost = host;
            this.myFile = doc.getContainingFile();
            this.myDocument = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            RngSchemaValidator.handleError(exception, this.myFile, this.myDocument, new RngSchemaValidator.ValidationMessageConsumer(){

                @Override
                public void onMessage(PsiElement context2, String message2) {
                    myHost.addMessage(context2, message2, Validator.ValidationHost.ErrorType.WARNING);
                }
            });
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            RngSchemaValidator.handleError(exception, this.myFile, this.myDocument, new RngSchemaValidator.ValidationMessageConsumer(){

                @Override
                public void onMessage(PsiElement context2, String message2) {
                    myHost.addMessage(context2, message2, Validator.ValidationHost.ErrorType.ERROR);
                }
            });
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            RngSchemaValidator.handleError(exception, this.myFile, this.myDocument, new RngSchemaValidator.ValidationMessageConsumer(){

                @Override
                public void onMessage(PsiElement context2, String message2) {
                    myHost.addMessage(context2, message2, Validator.ValidationHost.ErrorType.ERROR);
                }
            });
        }

        @Nullable
        public static ErrorHandler create(XmlDocument doc, Validator.ValidationHost host) {
            XmlTag rootTag = doc.getRootTag();
            if (rootTag == null) {
                return null;
            }
            return new MyErrorHandler(doc, host);
        }
    }
}

