/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a2\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0001H\u0007\u00a8\u0006\f"}, d2={"compareAuthority", "", "currentAuthority", "", "getBuiltInServerUrls", "", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "appendAccessToken", "built-in-server"})
public final class BuiltInWebBrowserUrlProviderKt {
    @JvmOverloads
    @NotNull
    public static final List<Url> getBuiltInServerUrls(@NotNull VirtualFile file2, @NotNull Project project2, @Nullable String currentAuthority, boolean appendAccessToken) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        if (currentAuthority != null && !BuiltInWebBrowserUrlProviderKt.compareAuthority(currentAuthority)) {
            return CollectionsKt.emptyList();
        }
        PathInfo pathInfo = WebServerPathToFileManager.Companion.getInstance(project2).getPathInfo(file2);
        if (pathInfo == null) {
            return CollectionsKt.emptyList();
        }
        PathInfo info = pathInfo;
        int effectiveBuiltInServerPort = BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort();
        String path = info.getPath();
        String string2 = currentAuthority;
        if (string2 == null) {
            string2 = "localhost:" + effectiveBuiltInServerPort;
        }
        String authority = string2;
        String query = appendAccessToken ? "?" + "_ijt" + "=" + BuiltInWebServerKt.acquireToken() : "";
        SmartList urls = new SmartList((Object)Urls.newHttpUrl(authority, "/" + project2.getName() + "/" + path, query));
        String path2 = info.getRootLessPathIfPossible();
        if (path2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            char c2 = '/';
            String string3 = project2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"project.name");
            String string4 = string3;
            StringBuilder stringBuilder2 = stringBuilder;
            String string5 = authority;
            SmartList smartList = urls;
            String string6 = String.valueOf(c2) + string4;
            smartList.add((Object)Urls.newHttpUrl(string5, stringBuilder2.append(string6).append('/').append(path2).toString(), query));
        }
        int defaultPort = BuiltInServerManager.getInstance().getPort();
        if (currentAuthority == null && defaultPort != effectiveBuiltInServerPort) {
            String defaultAuthority = "localhost:" + defaultPort;
            urls.add((Object)Urls.newHttpUrl(defaultAuthority, "/" + project2.getName() + "/" + path, query));
            if (path2 != null) {
                urls.add((Object)Urls.newHttpUrl(defaultAuthority, "/" + project2.getName() + "/" + path2, query));
            }
        }
        return (List)urls;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ List getBuiltInServerUrls$default(VirtualFile virtualFile, Project project2, String string2, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls(virtualFile, project2, string2, bl);
    }

    @JvmOverloads
    @NotNull
    public static final List<Url> getBuiltInServerUrls(@NotNull VirtualFile file2, @NotNull Project project2, @Nullable String currentAuthority) {
        return BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls$default(file2, project2, currentAuthority, false, 8, null);
    }

    public static final boolean compareAuthority(@Nullable String currentAuthority) {
        int portIndex;
        CharSequence charSequence = currentAuthority;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        String string2 = currentAuthority;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        if ((portIndex = StringsKt.indexOf$default((CharSequence)string2, (char)':', (int)0, (boolean)false, (int)6, null)) < 0) {
            return false;
        }
        String string3 = currentAuthority;
        int n2 = 0;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n2, portIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String host = string5;
        if (!BuiltInWebServerKt.isOwnHostName(host)) {
            return false;
        }
        String string6 = currentAuthority;
        int n3 = portIndex + 1;
        String string7 = string6;
        if (string7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n3);
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
        int port = StringUtil.parseInt((String)string8, (int)-1);
        return port == BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort() || port == BuiltInServerManager.getInstance().getPort();
    }
}

