/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.google.common.net.PercentEscaper;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.Strftime;

public class SsiProcessingState {
    protected static final String DEFAULT_CONFIG_ERR_MSG = "[an error occurred while processing this directive]";
    protected static final String DEFAULT_CONFIG_TIME_FMT = "%A, %d-%b-%Y %T %Z";
    protected static final String DEFAULT_CONFIG_SIZE_FMT = "abbrev";
    protected static final Escaper urlEscaper = new PercentEscaper(",:-_.*/!~'()", false);
    protected String configErrorMessage;
    protected String configTimeFmt;
    protected String configSizeFmt;
    protected final SsiExternalResolver ssiExternalResolver;
    protected final long lastModifiedDate;
    protected Strftime strftime;
    protected final SsiConditionalState conditionalState;
    private boolean alreadySet;

    public SsiProcessingState(@NotNull SsiExternalResolver ssiExternalResolver, long lastModifiedDate) {
        if (ssiExternalResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ssiExternalResolver", "org/jetbrains/builtInWebServer/ssi/SsiProcessingState", "<init>"));
        }
        this.configErrorMessage = DEFAULT_CONFIG_ERR_MSG;
        this.configTimeFmt = DEFAULT_CONFIG_TIME_FMT;
        this.configSizeFmt = DEFAULT_CONFIG_SIZE_FMT;
        this.conditionalState = new SsiConditionalState();
        this.ssiExternalResolver = ssiExternalResolver;
        this.lastModifiedDate = lastModifiedDate;
        this.setConfigTimeFormat(DEFAULT_CONFIG_TIME_FMT, true);
    }

    public void setConfigTimeFormat(String configTimeFmt, boolean fromConstructor) {
        this.configTimeFmt = configTimeFmt;
        this.strftime = new Strftime(configTimeFmt, Locale.US);
        this.setDateVariables(fromConstructor);
    }

    public String getVariableValue(String variableName) {
        return this.getVariableValue(variableName, "none");
    }

    public String getVariableValue(@NotNull String variableName, String encoding) {
        if (variableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "org/jetbrains/builtInWebServer/ssi/SsiProcessingState", "getVariableValue"));
        }
        String variableValue = this.ssiExternalResolver.getVariableValue(variableName);
        return variableValue == null ? null : this.encode(variableValue, encoding);
    }

    public String substituteVariables(String val) {
        int charEnd;
        if (val.indexOf(36) < 0 && val.indexOf(38) < 0) {
            return val;
        }
        val = val.replace("&lt;", "<");
        val = val.replace("&gt;", ">");
        val = val.replace("&quot;", "\"");
        val = val.replace("&amp;", "&");
        StringBuilder sb2 = new StringBuilder(val);
        int charStart = sb2.indexOf("&#");
        while (charStart > -1 && (charEnd = sb2.indexOf(";", charStart)) > -1) {
            char c2 = (char)Integer.parseInt(sb2.substring(charStart + 2, charEnd));
            sb2.delete(charStart, charEnd + 1);
            sb2.insert(charStart, c2);
            charStart = sb2.indexOf("&#");
        }
        int i2 = 0;
        while (i2 < sb2.length()) {
            String varName;
            String value2;
            while (i2 < sb2.length()) {
                if (sb2.charAt(i2) == '$') {
                    ++i2;
                    break;
                }
                ++i2;
            }
            if (i2 == sb2.length()) break;
            if (i2 > 1 && sb2.charAt(i2 - 2) == '\\') {
                sb2.deleteCharAt(i2 - 2);
                --i2;
                continue;
            }
            int nameStart = i2;
            int start2 = i2 - 1;
            char endChar = ' ';
            if (sb2.charAt(i2) == '{') {
                ++nameStart;
                endChar = '}';
            }
            while (i2 < sb2.length() && sb2.charAt(i2) != endChar) {
                ++i2;
            }
            int end = i2;
            int nameEnd = end++;
            if (endChar == '}') {
                // empty if block
            }
            if ((value2 = this.getVariableValue(varName = sb2.substring(nameStart, nameEnd))) == null) {
                value2 = "";
            }
            sb2.replace(start2, end, value2);
            i2 = start2 + value2.length();
        }
        return sb2.toString();
    }

    protected void setDateVariables(boolean fromConstructor) {
        if (fromConstructor && this.alreadySet) {
            return;
        }
        this.alreadySet = true;
        Date date = new Date();
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        this.ssiExternalResolver.setVariableValue("DATE_GMT", this.formatDate(date, timeZone));
        this.ssiExternalResolver.setVariableValue("DATE_LOCAL", this.formatDate(date, null));
        this.ssiExternalResolver.setVariableValue("LAST_MODIFIED", this.formatDate(new Date(this.lastModifiedDate), null));
    }

    @NotNull
    protected String formatDate(@NotNull Date date, @Nullable TimeZone timeZone) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "org/jetbrains/builtInWebServer/ssi/SsiProcessingState", "formatDate"));
        }
        if (timeZone == null) {
            String string2 = this.strftime.format(date);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/ssi/SsiProcessingState", "formatDate"));
            }
            return string2;
        }
        TimeZone oldTimeZone = this.strftime.getTimeZone();
        this.strftime.setTimeZone(timeZone);
        String retVal = this.strftime.format(date);
        this.strftime.setTimeZone(oldTimeZone);
        String string3 = retVal;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/ssi/SsiProcessingState", "formatDate"));
        }
        return string3;
    }

    @NotNull
    protected String encode(@NotNull String value2, @NotNull String encoding) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/builtInWebServer/ssi/SsiProcessingState", "encode"));
        }
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "org/jetbrains/builtInWebServer/ssi/SsiProcessingState", "encode"));
        }
        if (encoding.equalsIgnoreCase("url")) {
            String string2 = urlEscaper.escape(value2);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/ssi/SsiProcessingState", "encode"));
            }
            return string2;
        }
        if (encoding.equalsIgnoreCase("none")) {
            String string3 = value2;
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/ssi/SsiProcessingState", "encode"));
            }
            return string3;
        }
        if (encoding.equalsIgnoreCase("entity")) {
            String string4 = HtmlEscapers.htmlEscaper().escape(value2);
            if (string4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/ssi/SsiProcessingState", "encode"));
            }
            return string4;
        }
        throw new IllegalArgumentException("Unknown encoding: " + encoding);
    }

    static class SsiConditionalState {
        boolean branchTaken = false;
        int nestingCount = 0;
        boolean processConditionalCommandsOnly = false;

        SsiConditionalState() {
        }
    }
}

