/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;

public abstract class BreakpointTarget {
    public abstract <R> R accept(Visitor<R> var1);

    public abstract String toString();

    public static final class ScriptName
    extends BreakpointTarget {
        private final String name;

        public ScriptName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/BreakpointTarget$ScriptName", "<init>"));
            }
            this.name = name;
        }

        @NotNull
        public String getName() {
            String string2 = this.name;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BreakpointTarget$ScriptName", "getName"));
            }
            return string2;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public <R> R accept(@NotNull Visitor<R> visitor2) {
            if (visitor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/debugger/BreakpointTarget$ScriptName", "accept"));
            }
            return visitor2.visitScriptName(this.name);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            return this.name.equals(((ScriptName)o2).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static final class ScriptId
    extends BreakpointTarget {
        public final Script script;

        public ScriptId(@NotNull Script script) {
            if (script == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/debugger/BreakpointTarget$ScriptId", "<init>"));
            }
            this.script = script;
        }

        @Override
        public <R> R accept(Visitor<R> visitor2) {
            return visitor2.visitScript(this.script);
        }

        @Override
        public String toString() {
            return this.script.toString();
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            return this.script.equals(((ScriptId)o2).script);
        }

        public int hashCode() {
            return this.script.hashCode();
        }
    }

    public static interface Visitor<R> {
        public R visitScriptName(String var1);

        public R visitScript(Script var1);

        public R visitUnknown(BreakpointTarget var1);
    }
}

