/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;

public interface DebugEventListener
extends EventListener {
    default public void suspended(@NotNull SuspendContext<?> context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/DebugEventListener", "suspended"));
        }
    }

    default public void resumed() {
    }

    default public void scriptAdded(@NotNull Vm vm, @NotNull Script script, @Nullable String sourceMapUrl) {
        if (vm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "org/jetbrains/debugger/DebugEventListener", "scriptAdded"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/debugger/DebugEventListener", "scriptAdded"));
        }
    }

    default public void scriptRemoved(@NotNull Script script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/debugger/DebugEventListener", "scriptRemoved"));
        }
    }

    default public void scriptsCleared() {
    }

    default public void scriptContentChanged(@NotNull Script newScript) {
        if (newScript == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newScript", "org/jetbrains/debugger/DebugEventListener", "scriptContentChanged"));
        }
    }

    default public void navigated(String newUrl) {
    }

    default public void errorOccurred(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "org/jetbrains/debugger/DebugEventListener", "errorOccurred"));
        }
    }
}

