/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Variable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0014J\u0010\u0010\u0002\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/debugger/MemberFilterWithNameMappings;", "Lorg/jetbrains/debugger/MemberFilter;", "rawNameToSource", "", "", "(Ljava/util/Map;)V", "getRawNameToSource", "()Ljava/util/Map;", "hasNameMappings", "", "normalizeMemberName", "name", "variable", "Lorg/jetbrains/debugger/Variable;", "sourceNameToRaw", "script-debugger-ui"})
public class MemberFilterWithNameMappings
implements MemberFilter {
    @NotNull
    private final Map<String, String> rawNameToSource;

    @Override
    public boolean hasNameMappings() {
        return !this.rawNameToSource.isEmpty();
    }

    @Override
    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        String name = variable.getName();
        String sourceName = this.rawNameToSource.get(name);
        String string2 = sourceName;
        if (string2 == null) {
            String string3 = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
            string2 = this.normalizeMemberName(string3);
        }
        return string2;
    }

    @NotNull
    protected String normalizeMemberName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return name;
    }

    @Override
    @Nullable
    public String sourceNameToRaw(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (!this.hasNameMappings()) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.rawNameToSource.entrySet()) {
            if (!Intrinsics.areEqual((Object)entry.getValue(), (Object)name)) continue;
            return entry.getKey();
        }
        return null;
    }

    @NotNull
    protected final Map<String, String> getRawNameToSource() {
        return this.rawNameToSource;
    }

    public MemberFilterWithNameMappings(@NotNull Map<String, String> rawNameToSource) {
        Intrinsics.checkParameterIsNotNull(rawNameToSource, (String)"rawNameToSource");
        this.rawNameToSource = rawNameToSource;
    }

    public /* synthetic */ MemberFilterWithNameMappings(Map map2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(map2);
    }

    public MemberFilterWithNameMappings() {
        this(null, 1, null);
    }

    @Override
    public boolean isMemberVisible(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return MemberFilter.DefaultImpls.isMemberVisible(this, variable);
    }

    @Override
    @NotNull
    public Collection<Variable> getAdditionalVariables() {
        return MemberFilter.DefaultImpls.getAdditionalVariables(this);
    }
}

