/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XNumericValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000f\u001a\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0012H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"ARRAY_DESCRIPTION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "PROTOTYPE_PROP", "", "VariableView", "Lorg/jetbrains/debugger/VariableView;", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "createNumberPresentation", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "value", "getClassName", "Lorg/jetbrains/debugger/values/ObjectValue;", "getObjectValueDescription", "trimFunctionDescription", "Lorg/jetbrains/debugger/values/Value;", "script-debugger-ui"})
public final class VariableViewKt {
    private static final Pattern ARRAY_DESCRIPTION_PATTERN = Pattern.compile("^[a-zA-Z\\d]+\\[\\d+\\]$");
    private static final String PROTOTYPE_PROP = "__proto__";

    @NotNull
    public static final VariableView VariableView(@NotNull Variable variable, @NotNull VariableContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        String string2 = variable.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"variable.name");
        return new VariableView(string2, variable, context2);
    }

    @NotNull
    public static final String getClassName(@NotNull ObjectValue value2) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        String className = value2.getClassName();
        CharSequence charSequence = className;
        if (charSequence == null || charSequence.length() == 0) {
            string2 = "Object";
        } else {
            string2 = className;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
        }
        return string2;
    }

    @NotNull
    public static final String getObjectValueDescription(@NotNull ObjectValue value2) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        String description = value2.getValueString();
        CharSequence charSequence = description;
        if (charSequence == null || charSequence.length() == 0) {
            string2 = VariableViewKt.getClassName(value2);
        } else {
            string2 = description;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
        }
        return string2;
    }

    @NotNull
    public static final String trimFunctionDescription(@NotNull Value value2) {
        int endIndex;
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        String string2 = value2.getValueString();
        if (string2 == null) {
            return "";
        }
        String presentableValue = string2;
        for (endIndex = 0; endIndex < presentableValue.length() && !StringUtil.isLineBreak((char)presentableValue.charAt(endIndex)); ++endIndex) {
        }
        while (endIndex > 0 && Character.isWhitespace(presentableValue.charAt(endIndex - 1))) {
            --endIndex;
        }
        String string3 = presentableValue;
        int n2 = 0;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n2, endIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string5;
    }

    private static final XValuePresentation createNumberPresentation(String value2) {
        return Intrinsics.areEqual((Object)value2, (Object)PrimitiveValue.Companion.getNA_N_VALUE()) || Intrinsics.areEqual((Object)value2, (Object)PrimitiveValue.Companion.getINFINITY_VALUE()) ? (XValuePresentation)new XKeywordValuePresentation(value2) : (XValuePresentation)new XNumericValuePresentation(value2);
    }

    static {
        PROTOTYPE_PROP = PROTOTYPE_PROP;
    }

    @NotNull
    public static final /* synthetic */ String access$getPROTOTYPE_PROP$p() {
        return PROTOTYPE_PROP;
    }

    @NotNull
    public static final /* synthetic */ XValuePresentation access$createNumberPresentation(@NotNull String value2) {
        return VariableViewKt.createNumberPresentation(value2);
    }

    public static final /* synthetic */ Pattern access$getARRAY_DESCRIPTION_PATTERN$p() {
        return ARRAY_DESCRIPTION_PATTERN;
    }
}

