/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\fH\u0016J:\u0010\u001d\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0#2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0010\u0010$\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010&\u0018\u00010%2\u0006\u0010!\u001a\u00020\fH\u0016J\u0010\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u001eH\u0016J \u0010)\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006-"}, d2={"Lorg/jetbrains/debugger/sourcemap/OneLevelSourceMap;", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "outFile", "", "generatedMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "sourceIndexToMappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "sourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "hasNameMappings", "", "(Ljava/lang/String;Lorg/jetbrains/debugger/sourcemap/Mappings;[Lorg/jetbrains/debugger/sourcemap/MappingList;Lorg/jetbrains/debugger/sourcemap/SourceResolver;Z)V", "getGeneratedMappings", "()Lorg/jetbrains/debugger/sourcemap/Mappings;", "getHasNameMappings", "()Z", "getOutFile", "()Ljava/lang/String;", "getSourceIndexToMappings$script_debugger_backend", "()[Lorg/jetbrains/debugger/sourcemap/MappingList;", "[Lorg/jetbrains/debugger/sourcemap/MappingList;", "getSourceResolver", "()Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "sources", "Lcom/intellij/util/Url;", "getSources", "()[Lcom/intellij/util/Url;", "findSourceIndex", "", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "localFileUrlOnly", "sourceUrls", "", "resolver", "Lkotlin/Lazy;", "Lorg/jetbrains/debugger/sourcemap/SourceFileResolver;", "findSourceMappings", "sourceIndex", "processSourceMappingsInLine", "sourceLine", "mappingProcessor", "Lorg/jetbrains/debugger/sourcemap/MappingsProcessorInLine;", "script-debugger-backend"})
public final class OneLevelSourceMap
implements SourceMap {
    @Nullable
    private final String outFile;
    @NotNull
    private final Mappings generatedMappings;
    @NotNull
    private final MappingList[] sourceIndexToMappings;
    @NotNull
    private final SourceResolver sourceResolver;
    private final boolean hasNameMappings;

    @Override
    @NotNull
    public Url[] getSources() {
        return this.getSourceResolver().getCanonicalizedUrls$script_debugger_backend();
    }

    @Override
    public int findSourceIndex(@NotNull List<? extends Url> sourceUrls, @Nullable VirtualFile sourceFile, @Nullable Lazy<? extends SourceFileResolver> resolver, boolean localFileUrlOnly) {
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        int index = this.getSourceResolver().findSourceIndex(sourceUrls, sourceFile, localFileUrlOnly);
        if (index == -1 && resolver != null) {
            int n2;
            SourceFileResolver sourceFileResolver = (SourceFileResolver)resolver.getValue();
            if (sourceFileResolver != null) {
                SourceFileResolver sourceFileResolver2;
                SourceFileResolver it = sourceFileResolver2 = sourceFileResolver;
                n2 = this.getSourceResolver().findSourceIndex$script_debugger_backend(sourceFile, it);
            } else {
                n2 = -1;
            }
            return n2;
        }
        return index;
    }

    @Override
    @NotNull
    public MappingList findSourceMappings(int sourceIndex) {
        Object object = ((Object[])this.sourceIndexToMappings)[sourceIndex];
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (MappingList)object;
    }

    @Override
    public int findSourceIndex(@NotNull VirtualFile sourceFile, boolean localFileUrlOnly) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        return this.getSourceResolver().findSourceIndexByFile$script_debugger_backend(sourceFile, localFileUrlOnly);
    }

    @Override
    public boolean processSourceMappingsInLine(int sourceIndex, int sourceLine, @NotNull MappingsProcessorInLine mappingProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)mappingProcessor, (String)"mappingProcessor");
        return this.findSourceMappings(sourceIndex).processMappingsInLine(sourceLine, mappingProcessor);
    }

    @Override
    @Nullable
    public String getOutFile() {
        return this.outFile;
    }

    @Override
    @NotNull
    public Mappings getGeneratedMappings() {
        return this.generatedMappings;
    }

    @NotNull
    public final MappingList[] getSourceIndexToMappings$script_debugger_backend() {
        return this.sourceIndexToMappings;
    }

    @Override
    @NotNull
    public SourceResolver getSourceResolver() {
        return this.sourceResolver;
    }

    @Override
    public boolean getHasNameMappings() {
        return this.hasNameMappings;
    }

    public OneLevelSourceMap(@Nullable String outFile, @NotNull Mappings generatedMappings2, @NotNull MappingList[] sourceIndexToMappings, @NotNull SourceResolver sourceResolver, boolean hasNameMappings) {
        Intrinsics.checkParameterIsNotNull((Object)generatedMappings2, (String)"generatedMappings");
        Intrinsics.checkParameterIsNotNull((Object)sourceIndexToMappings, (String)"sourceIndexToMappings");
        Intrinsics.checkParameterIsNotNull((Object)sourceResolver, (String)"sourceResolver");
        this.outFile = outFile;
        this.generatedMappings = generatedMappings2;
        this.sourceIndexToMappings = sourceIndexToMappings;
        this.sourceResolver = sourceResolver;
        this.hasNameMappings = hasNameMappings;
    }

    @Override
    @Nullable
    public Mappings findSourceMappings(@NotNull List<? extends Url> sourceUrls, @Nullable VirtualFile sourceFile, @Nullable Lazy<? extends SourceFileResolver> resolver, boolean localFileUrlOnly) {
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        return SourceMap.DefaultImpls.findSourceMappings(this, sourceUrls, sourceFile, resolver, localFileUrlOnly);
    }

    @Override
    public boolean processSourceMappingsInLine(@NotNull List<? extends Url> sourceUrls, int sourceLine, @NotNull MappingsProcessorInLine mappingProcessor, @Nullable VirtualFile sourceFile, @Nullable Lazy<? extends SourceFileResolver> resolver, boolean localFileUrlOnly) {
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)mappingProcessor, (String)"mappingProcessor");
        return SourceMap.DefaultImpls.processSourceMappingsInLine(this, sourceUrls, sourceLine, mappingProcessor, sourceFile, resolver, localFileUrlOnly);
    }

    @Override
    public int getSourceLineByRawLocation(int rawLine, int rawColumn) {
        return SourceMap.DefaultImpls.getSourceLineByRawLocation(this, rawLine, rawColumn);
    }
}

