/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.platform.ProjectSetReader;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

public class ProjectSetRequestHandler
extends RestService {
    @Override
    protected boolean isMethodSupported(@NotNull HttpMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/ide/ProjectSetRequestHandler", "isMethodSupported"));
        }
        return method2 == HttpMethod.POST;
    }

    @Override
    @NotNull
    protected String getServiceName() {
        if ("openProjectSet" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/ProjectSetRequestHandler", "getServiceName"));
        }
        return "openProjectSet";
    }

    @Override
    protected boolean isPrefixlessAllowed() {
        return true;
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context2) throws IOException {
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/ProjectSetRequestHandler", "execute"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/ProjectSetRequestHandler", "execute"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/ProjectSetRequestHandler", "execute"));
        }
        JsonObject descriptor2 = new JsonParser().parse(ProjectSetRequestHandler.createJsonReader(request2)).getAsJsonObject();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            new ProjectSetReader().readDescriptor(descriptor2, null);
            ProjectSetRequestHandler.activateLastFocusedFrame();
        });
        ProjectSetRequestHandler.sendOk(request2, context2);
        return null;
    }

    @Override
    public boolean isAccessible(@NotNull HttpRequest request2) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/ProjectSetRequestHandler", "isAccessible"));
        }
        return true;
    }
}

