/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

public abstract class RestService
extends HttpRequestHandler {
    protected static final Logger LOG = Logger.getInstance(RestService.class);
    public static final String PREFIX = "api";
    protected final NotNullLazyValue<Gson> gson = new NotNullLazyValue<Gson>(){

        @NotNull
        protected Gson compute() {
            Gson gson2 = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            if (gson2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/RestService$1", "compute"));
            }
            return gson2;
        }
    };
    private final LoadingCache<InetAddress, AtomicInteger> abuseCounter = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(CacheLoader.from(AtomicInteger::new));
    private final Cache<String, Boolean> trustedOrigins = CacheBuilder.newBuilder().maximumSize(1024L).expireAfterWrite(1L, TimeUnit.DAYS).build();

    @Override
    public final boolean isSupported(@NotNull FullHttpRequest request2) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "isSupported"));
        }
        if (!this.isMethodSupported(request2.method())) {
            return false;
        }
        String uri2 = request2.uri();
        if (this.isPrefixlessAllowed() && RestService.checkPrefix(uri2, this.getServiceName())) {
            return true;
        }
        String serviceName = this.getServiceName();
        int minLength = 1 + PREFIX.length() + 1 + serviceName.length();
        if (uri2.length() >= minLength && uri2.charAt(0) == '/' && uri2.regionMatches(true, 1, PREFIX, 0, PREFIX.length()) && uri2.regionMatches(true, 2 + PREFIX.length(), serviceName, 0, serviceName.length())) {
            if (uri2.length() == minLength) {
                return true;
            }
            char c2 = uri2.charAt(minLength);
            return c2 == '/' || c2 == '?';
        }
        return false;
    }

    protected boolean isPrefixlessAllowed() {
        return false;
    }

    @NotNull
    protected abstract String getServiceName();

    protected abstract boolean isMethodSupported(@NotNull HttpMethod var1);

    @Override
    public final boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context2) throws IOException {
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/RestService", "process"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "process"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/RestService", "process"));
        }
        try {
            AtomicInteger counter = (AtomicInteger)this.abuseCounter.get((Object)((InetSocketAddress)context2.channel().remoteAddress()).getAddress());
            if (counter.incrementAndGet() > Registry.intValue((String)"ide.rest.api.requests.per.minute", (int)30)) {
                Responses.send(Responses.orInSafeMode(HttpResponseStatus.TOO_MANY_REQUESTS, HttpResponseStatus.OK), context2.channel(), (HttpRequest)request2);
                return true;
            }
            if (!this.isHostTrusted(request2)) {
                Responses.send(Responses.orInSafeMode(HttpResponseStatus.FORBIDDEN, HttpResponseStatus.OK), context2.channel(), (HttpRequest)request2);
                return true;
            }
            String error = this.execute(urlDecoder, request2, context2);
            if (error != null) {
                Responses.send(HttpResponseStatus.BAD_REQUEST, context2.channel(), (HttpRequest)request2, error);
            }
        }
        catch (Throwable e2) {
            HttpResponseStatus status;
            if (e2 instanceof MalformedJsonException || e2 instanceof IllegalStateException && e2.getMessage().startsWith("Expected a ")) {
                LOG.warn(e2);
                status = HttpResponseStatus.BAD_REQUEST;
            } else {
                LOG.error(e2);
                status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            }
            Responses.send(status, context2.channel(), (HttpRequest)request2, ExceptionUtil.getThrowableText((Throwable)e2));
        }
        return true;
    }

    protected boolean isHostTrusted(@NotNull FullHttpRequest request2) throws InterruptedException, InvocationTargetException {
        String host;
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "isHostTrusted"));
        }
        if (BuiltInWebServerKt.isSignedRequest((HttpRequest)request2)) {
            return true;
        }
        String referrer = NettyKt.getOrigin((HttpRequest)request2);
        if (referrer == null) {
            referrer = NettyKt.getReferrer((HttpRequest)request2);
        }
        try {
            host = StringUtil.nullize(referrer == null ? null : new URI(referrer).getHost());
        }
        catch (URISyntaxException ignored) {
            return false;
        }
        Ref isTrusted = Ref.create();
        if (host != null) {
            if (NetUtils.isLocalhost((String)host)) {
                isTrusted.set((Object)true);
            } else {
                isTrusted.set(this.trustedOrigins.getIfPresent((Object)host));
            }
        }
        if (isTrusted.isNull()) {
            SwingUtilities.invokeAndWait(() -> {
                isTrusted.set((Object)ProjectUtil.showYesNoDialog(IdeBundle.message((String)"warning.use.rest.api", (Object[])new Object[]{this.getServiceName(), ObjectUtils.chooseNotNull((Object)host, (Object)"unknown host")}), "title.use.rest.api"));
                if (host != null) {
                    this.trustedOrigins.put((Object)host, isTrusted.get());
                }
            });
        }
        return (Boolean)isTrusted.get();
    }

    protected static void activateLastFocusedFrame() {
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (frame instanceof Window) {
            ((Window)frame).toFront();
        }
    }

    @Nullable(value="error text or null if successful")
    public abstract String execute(@NotNull QueryStringDecoder var1, @NotNull FullHttpRequest var2, @NotNull ChannelHandlerContext var3) throws IOException;

    @NotNull
    protected static JsonReader createJsonReader(@NotNull FullHttpRequest request2) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "createJsonReader"));
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new ByteBufInputStream(request2.content()), CharsetToolkit.UTF8_CHARSET));
        reader.setLenient(true);
        JsonReader jsonReader = reader;
        if (jsonReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/RestService", "createJsonReader"));
        }
        return jsonReader;
    }

    @NotNull
    protected static JsonWriter createJsonWriter(@NotNull OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/ide/RestService", "createJsonWriter"));
        }
        JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(out, CharsetToolkit.UTF8_CHARSET));
        writer.setIndent("  ");
        JsonWriter jsonWriter = writer;
        if (jsonWriter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/RestService", "createJsonWriter"));
        }
        return jsonWriter;
    }

    @Nullable
    protected static Project getLastFocusedOrOpenedProject() {
        Project project2;
        IdeFrame lastFocusedFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project project3 = project2 = lastFocusedFrame == null ? null : lastFocusedFrame.getProject();
        if (project2 == null) {
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            return openProjects.length > 0 ? openProjects[0] : null;
        }
        return project2;
    }

    protected static void sendOk(@NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context2) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "sendOk"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/RestService", "sendOk"));
        }
        RestService.sendStatus(HttpResponseStatus.OK, HttpUtil.isKeepAlive((HttpMessage)request2), context2.channel());
    }

    protected static void sendStatus(@NotNull HttpResponseStatus status, boolean keepAlive, @NotNull Channel channel) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/ide/RestService", "sendStatus"));
        }
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/ide/RestService", "sendStatus"));
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        HttpUtil.setContentLength((HttpMessage)response, (long)0L);
        Responses.addCommonHeaders((HttpResponse)response);
        Responses.addNoCache((HttpResponse)response);
        if (keepAlive) {
            HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
        }
        response.headers().set("X-Frame-Options", (Object)"Deny");
        Responses.send((HttpResponse)response, channel, !keepAlive);
    }

    protected static void send(@NotNull BufferExposingByteArrayOutputStream byteOut, @NotNull HttpRequest request2, @NotNull ChannelHandlerContext context2) {
        if (byteOut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byteOut", "org/jetbrains/ide/RestService", "send"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "send"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/RestService", "send"));
        }
        FullHttpResponse response = Responses.response("application/json", Unpooled.wrappedBuffer((byte[])byteOut.getInternalBuffer(), (int)0, (int)byteOut.size()));
        Responses.addNoCache((HttpResponse)response);
        response.headers().set("X-Frame-Options", (Object)"Deny");
        Responses.send((HttpResponse)response, context2.channel(), request2);
    }

    @Nullable
    protected static String getStringParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/ide/RestService", "getStringParameter"));
        }
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/RestService", "getStringParameter"));
        }
        return (String)ContainerUtil.getLastItem((List)((List)urlDecoder.parameters().get(name)));
    }

    protected static int getIntParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/ide/RestService", "getIntParameter"));
        }
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/RestService", "getIntParameter"));
        }
        return StringUtilRt.parseInt((String)StringUtil.nullize((String)((String)ContainerUtil.getLastItem((List)((List)urlDecoder.parameters().get(name)))), (boolean)true), (int)-1);
    }

    protected static boolean getBooleanParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/ide/RestService", "getBooleanParameter"));
        }
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/RestService", "getBooleanParameter"));
        }
        return RestService.getBooleanParameter(name, urlDecoder, false);
    }

    protected static boolean getBooleanParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder, boolean defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/ide/RestService", "getBooleanParameter"));
        }
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/RestService", "getBooleanParameter"));
        }
        List values = (List)urlDecoder.parameters().get(name);
        if (ContainerUtil.isEmpty((Collection)values)) {
            return defaultValue;
        }
        String value2 = (String)values.get(values.size() - 1);
        return value2.isEmpty() || Boolean.parseBoolean(value2);
    }
}

