/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.NettyUtil;

@ChannelHandler.Sharable
public final class ChannelExceptionHandler
extends ChannelHandlerAdapter {
    private static final Logger LOG = Logger.getInstance(ChannelExceptionHandler.class);
    private static final ChannelHandler INSTANCE = new ChannelExceptionHandler();

    private ChannelExceptionHandler() {
    }

    @NotNull
    public static ChannelHandler getInstance() {
        ChannelHandler channelHandler = INSTANCE;
        if (channelHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/ChannelExceptionHandler", "getInstance"));
        }
        return channelHandler;
    }

    public void exceptionCaught(ChannelHandlerContext context2, Throwable cause) throws Exception {
        NettyUtil.logAndClose(cause, LOG, context2.channel());
    }
}

