/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.util.io.CharSequenceBackedByChars;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BufferToCharsKt;
import org.jetbrains.io.Decoder;

public abstract class MessageDecoder
extends Decoder {
    protected int contentLength;
    protected final StringBuilder builder = new StringBuilder(64);
    private CharBuffer chunkedContent;
    private int consumedContentByteCount = 0;

    protected final int parseContentLength() {
        return MessageDecoder.parseInt(this.builder, 0, false, 10);
    }

    @Nullable
    protected final CharSequence readChars(@NotNull ByteBuf input) throws IOException {
        String result2;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/io/MessageDecoder", "readChars"));
        }
        int readableBytes = input.readableBytes();
        if (readableBytes == 0) {
            input.release();
            return null;
        }
        int required = this.contentLength - this.consumedContentByteCount;
        if (readableBytes < required) {
            if (this.chunkedContent == null) {
                this.chunkedContent = CharBuffer.allocate(this.contentLength);
            }
            BufferToCharsKt.readIntoCharBuffer(input, readableBytes, this.chunkedContent);
            this.consumedContentByteCount += readableBytes;
            input.release();
            return null;
        }
        CharBuffer charBuffer = this.chunkedContent;
        if (charBuffer != null) {
            this.chunkedContent = null;
            this.consumedContentByteCount = 0;
            BufferToCharsKt.readIntoCharBuffer(input, required, charBuffer);
            result2 = new CharSequenceBackedByChars(charBuffer);
        } else {
            result2 = input.toString(input.readerIndex(), required, StandardCharsets.UTF_8);
        }
        input.readerIndex(input.readerIndex() + required);
        return result2;
    }

    @Override
    public void channelInactive(ChannelHandlerContext context2) throws Exception {
        try {
            this.chunkedContent = null;
        }
        finally {
            super.channelInactive(context2);
        }
    }

    public static boolean readUntil(char what, @NotNull ByteBuf buffer, @NotNull StringBuilder builder) {
        int i2;
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/MessageDecoder", "readUntil"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/io/MessageDecoder", "readUntil"));
        }
        int n2 = buffer.writerIndex();
        for (i2 = buffer.readerIndex(); i2 < n2; ++i2) {
            char c2 = (char)buffer.getByte(i2);
            if (c2 == what) {
                buffer.readerIndex(i2 + 1);
                return true;
            }
            builder.append(c2);
        }
        buffer.readerIndex(i2);
        return false;
    }

    public static void skipWhitespace(@NotNull ByteBuf buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/MessageDecoder", "skipWhitespace"));
        }
        int n2 = buffer.writerIndex();
        for (int i2 = buffer.readerIndex(); i2 < n2; ++i2) {
            char c2 = (char)buffer.getByte(i2);
            if (c2 == ' ') continue;
            buffer.readerIndex(i2);
            return;
        }
        buffer.readerIndex(n2);
    }

    public static int parseInt(@NotNull CharSequence value2, int start2, boolean isNegative, int radix) {
        int i2;
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/io/MessageDecoder", "parseInt"));
        }
        int end = value2.length();
        int result2 = 0;
        for (i2 = start2; i2 < end; ++i2) {
            int digit;
            char c2 = value2.charAt(i2);
            int n2 = c2 <= '9' ? c2 - 48 : (c2 <= 'Z' && c2 >= 'A' ? c2 - 65 + 10 : (digit = c2 <= 'z' && c2 >= 'a' ? c2 - 97 + 10 : -1));
            if (digit < 0 || digit >= radix) break;
            int newResult = result2 * radix - digit;
            if (newResult > result2) {
                throw new NumberFormatException("Overflow parsing " + value2.subSequence(start2, end));
            }
            result2 = newResult;
        }
        if (result2 == 0 && (end == 0 || value2.charAt(i2 - 1) != '0')) {
            throw new NumberFormatException("Invalid integer representation for " + value2.subSequence(start2, end));
        }
        if (result2 == Integer.MIN_VALUE && !isNegative) {
            throw new NumberFormatException("Overflow parsing " + value2.subSequence(start2, end));
        }
        return isNegative ? result2 : -result2;
    }
}

