/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc.socket;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BinaryRequestHandler;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.jsonRpc.JsonRpcServer;
import org.jetbrains.io.jsonRpc.JsonRpcServerKt;
import org.jetbrains.io.jsonRpc.socket.SocketClient;

public class RpcBinaryRequestHandler
extends BinaryRequestHandler
implements ExceptionHandler,
ClientListener {
    private static final Logger LOG = Logger.getInstance(RpcBinaryRequestHandler.class);
    private static final UUID ID = UUID.fromString("69957EEB-AFB8-4036-A9A8-00D2D022F9BD");
    private final AtomicNotNullLazyValue<ClientManager> clientManager = new AtomicNotNullLazyValue<ClientManager>(){

        @NotNull
        protected ClientManager compute() {
            ClientManager result2 = new ClientManager(RpcBinaryRequestHandler.this, RpcBinaryRequestHandler.this, null);
            Disposable serverDisposable = BuiltInServerManager.getInstance().getServerDisposable();
            assert (serverDisposable != null);
            Disposer.register((Disposable)serverDisposable, (Disposable)result2);
            RpcBinaryRequestHandler.this.rpcServer = new JsonRpcServer(result2);
            JsonRpcServerKt.registerFromEp(RpcBinaryRequestHandler.this.rpcServer);
            ClientManager clientManager = result2;
            if (clientManager == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler$1", "compute"));
            }
            return clientManager;
        }
    };
    private JsonRpcServer rpcServer;

    @NotNull
    public JsonRpcServer getRpcServer() {
        this.clientManager.getValue();
        JsonRpcServer jsonRpcServer = this.rpcServer;
        if (jsonRpcServer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler", "getRpcServer"));
        }
        return jsonRpcServer;
    }

    @NotNull
    public UUID getId() {
        UUID uUID = ID;
        if (uUID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler", "getId"));
        }
        return uUID;
    }

    @NotNull
    public ChannelHandler getInboundHandler(@NotNull ChannelHandlerContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler", "getInboundHandler"));
        }
        SocketClient client = new SocketClient(context2.channel());
        context2.channel().attr(ClientManagerKt.getCLIENT()).set((Object)client);
        ((ClientManager)this.clientManager.getValue()).addClient(client);
        this.connected(client, null);
        MyDecoder myDecoder = new MyDecoder(client);
        if (myDecoder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler", "getInboundHandler"));
        }
        return myDecoder;
    }

    @Override
    public void exceptionCaught(@NotNull Throwable e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler", "exceptionCaught"));
        }
        LOG.error(e2);
    }

    @Override
    public void connected(@NotNull Client client, @Nullable Map<String, List<String>> parameters) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler", "connected"));
        }
    }

    @Override
    public void disconnected(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler", "disconnected"));
        }
    }

    private class MyDecoder
    extends MessageDecoder {
        private State state;
        private final SocketClient client;

        public MyDecoder(SocketClient client) {
            if (client == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler$MyDecoder", "<init>"));
            }
            this.state = State.LENGTH;
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageReceived(@NotNull ChannelHandlerContext context2, @NotNull ByteBuf input) throws Exception {
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler$MyDecoder", "messageReceived"));
            }
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/io/jsonRpc/socket/RpcBinaryRequestHandler$MyDecoder", "messageReceived"));
            }
            block9: while (true) {
                switch (this.state) {
                    case LENGTH: {
                        ByteBuf buffer = this.getBufferIfSufficient(input, 4, context2);
                        if (buffer == null) {
                            return;
                        }
                        this.state = State.CONTENT;
                        this.contentLength = buffer.readInt();
                    }
                    case CONTENT: {
                        CharSequence content2 = this.readChars(input);
                        if (content2 == null) {
                            return;
                        }
                        try {
                            RpcBinaryRequestHandler.this.rpcServer.messageReceived(this.client, content2);
                            continue block9;
                        }
                        catch (Throwable e2) {
                            ((ClientManager)RpcBinaryRequestHandler.this.clientManager.getValue()).getExceptionHandler().exceptionCaught(e2);
                            continue block9;
                        }
                        finally {
                            this.contentLength = 0;
                            this.state = State.LENGTH;
                            continue block9;
                        }
                    }
                }
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext context2) throws Exception {
            Client client = (Client)((Object)context2.channel().attr(ClientManagerKt.getCLIENT()).get());
            if (client != null) {
                ((ClientManager)RpcBinaryRequestHandler.this.clientManager.getValue()).disconnectClient(context2.channel(), client, false);
            }
        }
    }

    private static enum State {
        LENGTH,
        CONTENT;

    }
}

