/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.MessageChannelHandler;
import org.jetbrains.io.webSocket.WebSocketClient;

public abstract class WebSocketHandshakeHandler
extends HttpRequestHandler
implements ClientListener,
ExceptionHandler {
    private static final Logger LOG = Logger.getInstance(WebSocketHandshakeHandler.class);
    private final AtomicNotNullLazyValue<ClientManager> clientManager = new AtomicNotNullLazyValue<ClientManager>(){

        @NotNull
        protected ClientManager compute() {
            ClientManager result2 = new ClientManager(WebSocketHandshakeHandler.this, WebSocketHandshakeHandler.this, null);
            Disposable serverDisposable = BuiltInServerManager.getInstance().getServerDisposable();
            assert (serverDisposable != null);
            Disposer.register((Disposable)serverDisposable, (Disposable)result2);
            WebSocketHandshakeHandler.this.serverCreated(result2);
            ClientManager clientManager = result2;
            if (clientManager == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler$1", "compute"));
            }
            return clientManager;
        }
    };

    @Override
    public boolean isSupported(@NotNull FullHttpRequest request2) {
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "isSupported"));
        }
        return request2.method() == HttpMethod.GET && "WebSocket".equalsIgnoreCase(request2.headers().getAsString((CharSequence)HttpHeaderNames.UPGRADE)) && request2.uri().length() > 2;
    }

    protected void serverCreated(@NotNull ClientManager server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "serverCreated"));
        }
    }

    @Override
    public void exceptionCaught(@NotNull Throwable e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "exceptionCaught"));
        }
        NettyUtil.log(e2, LOG);
    }

    @Override
    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context2) {
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "process"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "process"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "process"));
        }
        this.handleWebSocketRequest(context2, request2, urlDecoder);
        return true;
    }

    private void handleWebSocketRequest(final @NotNull ChannelHandlerContext context2, @NotNull FullHttpRequest request2, final @NotNull QueryStringDecoder uriDecoder) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "handleWebSocketRequest"));
        }
        if (request2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "handleWebSocketRequest"));
        }
        if (uriDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uriDecoder", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "handleWebSocketRequest"));
        }
        WebSocketServerHandshakerFactory factory2 = new WebSocketServerHandshakerFactory("ws://" + request2.headers().getAsString((CharSequence)HttpHeaderNames.HOST) + uriDecoder.path(), null, false, 0x6400000);
        WebSocketServerHandshaker handshaker = factory2.newHandshaker((HttpRequest)request2);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)context2.channel());
            return;
        }
        if (!context2.channel().isOpen()) {
            return;
        }
        final WebSocketClient client = new WebSocketClient(context2.channel(), handshaker);
        context2.channel().attr(ClientManagerKt.getCLIENT()).set((Object)client);
        handshaker.handshake(context2.channel(), request2).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future2) throws Exception {
                if (future2.isSuccess()) {
                    ClientManager clientManager = (ClientManager)WebSocketHandshakeHandler.this.clientManager.getValue();
                    clientManager.addClient(client);
                    MessageChannelHandler messageChannelHandler = new MessageChannelHandler(clientManager, WebSocketHandshakeHandler.this.getMessageServer());
                    BuiltInServer.replaceDefaultHandler(context2, (ChannelHandler)messageChannelHandler);
                    ChannelHandlerContext messageChannelHandlerContext = context2.pipeline().context((ChannelHandler)messageChannelHandler);
                    context2.pipeline().addBefore(messageChannelHandlerContext.name(), "webSocketFrameAggregator", (ChannelHandler)new WebSocketFrameAggregator(0x6400000));
                    messageChannelHandlerContext.channel().attr(ClientManagerKt.getCLIENT()).set((Object)client);
                    WebSocketHandshakeHandler.this.connected(client, uriDecoder.parameters());
                }
            }
        });
    }

    @NotNull
    protected abstract MessageServer getMessageServer();

    @Override
    public void connected(@NotNull Client client, @Nullable Map<String, List<String>> parameters) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "connected"));
        }
    }
}

