/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl.elements;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.artifact.elements.JpsLibraryFilesPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElementFactory;
import org.jetbrains.jps.model.artifact.elements.ex.JpsComplexPackagingElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.JpsOrderRootType;

public class JpsLibraryFilesPackagingElementImpl
extends JpsComplexPackagingElementBase<JpsLibraryFilesPackagingElementImpl>
implements JpsLibraryFilesPackagingElement {
    private static final JpsElementChildRole<JpsLibraryReference> LIBRARY_REFERENCE_CHILD_ROLE = JpsElementChildRoleBase.create((String)"library reference");

    public JpsLibraryFilesPackagingElementImpl(@NotNull JpsLibraryReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jps/model/artifact/impl/elements/JpsLibraryFilesPackagingElementImpl", "<init>"));
        }
        this.myContainer.setChild(LIBRARY_REFERENCE_CHILD_ROLE, (JpsElement)reference);
    }

    private JpsLibraryFilesPackagingElementImpl(JpsLibraryFilesPackagingElementImpl original) {
        super((JpsComplexPackagingElementBase)original);
    }

    @NotNull
    public JpsLibraryFilesPackagingElementImpl createCopy() {
        JpsLibraryFilesPackagingElementImpl jpsLibraryFilesPackagingElementImpl = new JpsLibraryFilesPackagingElementImpl(this);
        if (jpsLibraryFilesPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsLibraryFilesPackagingElementImpl", "createCopy"));
        }
        return jpsLibraryFilesPackagingElementImpl;
    }

    @NotNull
    public JpsLibraryReference getLibraryReference() {
        JpsLibraryReference jpsLibraryReference = (JpsLibraryReference)this.myContainer.getChild(LIBRARY_REFERENCE_CHILD_ROLE);
        if (jpsLibraryReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsLibraryFilesPackagingElementImpl", "getLibraryReference"));
        }
        return jpsLibraryReference;
    }

    public List<JpsPackagingElement> getSubstitution() {
        JpsLibrary library = (JpsLibrary)this.getLibraryReference().resolve();
        if (library == null) {
            return Collections.emptyList();
        }
        ArrayList<JpsPackagingElement> result2 = new ArrayList<JpsPackagingElement>();
        for (File file2 : library.getFiles(JpsOrderRootType.COMPILED)) {
            String path = FileUtil.toSystemIndependentName((String)file2.getAbsolutePath());
            if (file2.isDirectory()) {
                result2.add((JpsPackagingElement)JpsPackagingElementFactory.getInstance().createDirectoryCopy(path));
                continue;
            }
            result2.add((JpsPackagingElement)JpsPackagingElementFactory.getInstance().createFileCopy(path, null));
        }
        return result2;
    }
}

