/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.service.SharedThreadPool;

public class JdkVersionDetectorImpl
extends JdkVersionDetector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.SdkVersionUtil");
    private static final JdkVersionDetector.ActionRunner ACTION_RUNNER = new JdkVersionDetector.ActionRunner(){

        public Future<?> run(Runnable runnable2) {
            return SharedThreadPool.getInstance().executeOnPooledThread(runnable2);
        }
    };

    @Nullable
    public String detectJdkVersion(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "detectJdkVersion"));
        }
        return this.detectJdkVersion(homePath, ACTION_RUNNER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String detectJdkVersion(@NotNull String homePath, @NotNull JdkVersionDetector.ActionRunner runner) {
        JdkVersionDetector.JdkVersionInfo info;
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "detectJdkVersion"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "detectJdkVersion"));
        }
        File rtFile = new File(homePath, "jre/lib/rt.jar");
        if (rtFile.isFile()) {
            try (JarFile rtJar = new JarFile(rtFile, false);){
                String version;
                Manifest manifest = rtJar.getManifest();
                if (manifest != null && (version = manifest.getMainAttributes().getValue("Implementation-Version")) != null) {
                    String string2 = "java version \"" + version + "\"";
                    return string2;
                }
            }
            catch (IOException e2) {
                LOG.info((Throwable)e2);
            }
        }
        if ((info = this.detectJdkVersionInfo(homePath, runner)) == null) return null;
        String string2 = info.getVersion();
        return string2;
    }

    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "detectJdkVersionInfo"));
        }
        return this.detectJdkVersionInfo(homePath, ACTION_RUNNER);
    }

    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(@NotNull String homePath, @NotNull JdkVersionDetector.ActionRunner runner) {
        String javaExe;
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "detectJdkVersionInfo"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "detectJdkVersionInfo"));
        }
        File releaseFile = new File(homePath, "release");
        if (releaseFile.isFile()) {
            try {
                Properties p2 = new Properties();
                p2.load(new FileInputStream(releaseFile));
                String version = p2.getProperty("JAVA_FULL_VERSION", p2.getProperty("JAVA_VERSION"));
                if (version != null) {
                    String arch;
                    int i2 = (version = StringUtil.unquoteString((String)version)).indexOf(43);
                    if (i2 > 0) {
                        version = version.substring(0, i2);
                    }
                    boolean x64 = "x86_64".equals(arch = StringUtil.unquoteString((String)p2.getProperty("OS_ARCH", ""))) || "amd64".equals(arch);
                    return new JdkVersionDetector.JdkVersionInfo("java version \"" + version + "\"", x64 ? Bitness.x64 : Bitness.x32);
                }
            }
            catch (IOException e2) {
                LOG.info((Throwable)e2);
            }
        }
        if (new File(javaExe = homePath + File.separator + "bin" + File.separator + (SystemInfo.isWindows ? "java.exe" : "java")).canExecute()) {
            try {
                Process process2 = new ProcessBuilder(javaExe, "-version").redirectErrorStream(true).start();
                VersionOutputReader reader = new VersionOutputReader(process2.getInputStream(), runner);
                try {
                    process2.waitFor();
                }
                catch (InterruptedException e3) {
                    LOG.info((Throwable)e3);
                    process2.destroy();
                }
                return reader.getVersionInfo();
            }
            catch (IOException e4) {
                LOG.info((Throwable)e4);
            }
        }
        return null;
    }

    private static class VersionOutputReader
    extends BaseOutputReader {
        private static final BaseOutputReader.Options OPTIONS = new BaseOutputReader.Options(){

            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.BLOCKING;
            }

            public boolean splitToLines() {
                return true;
            }

            public boolean sendIncompleteLines() {
                return false;
            }

            public boolean withSeparators() {
                return false;
            }
        };
        private final JdkVersionDetector.ActionRunner myRunner;
        private final List<String> myLines;

        public VersionOutputReader(@NotNull InputStream stream, @NotNull JdkVersionDetector.ActionRunner runner) {
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl$VersionOutputReader", "<init>"));
            }
            if (runner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl$VersionOutputReader", "<init>"));
            }
            super(stream, CharsetToolkit.getDefaultSystemCharset(), OPTIONS);
            this.myRunner = runner;
            this.myLines = new CopyOnWriteArrayList<String>();
            this.start("java -version");
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl$VersionOutputReader", "executeOnPooledThread"));
            }
            Future future2 = this.myRunner.run(runnable2);
            if (future2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl$VersionOutputReader", "executeOnPooledThread"));
            }
            return future2;
        }

        protected void onTextAvailable(@NotNull String text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl$VersionOutputReader", "onTextAvailable"));
            }
            this.myLines.add(text2);
        }

        @Nullable
        public JdkVersionDetector.JdkVersionInfo getVersionInfo() {
            String version = null;
            Bitness arch = Bitness.x32;
            for (String line : this.myLines) {
                if (line.contains("version")) {
                    if (version != null) continue;
                    version = line;
                    continue;
                }
                if (!line.contains("64-Bit") && !line.contains("x86_64") && !line.contains("amd64")) continue;
                arch = Bitness.x64;
            }
            return version != null ? new JdkVersionDetector.JdkVersionInfo(version, arch) : null;
        }
    }
}

