/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.ExplodedDirectoryModuleExtension;
import org.jetbrains.jps.model.java.JavaModuleIndex;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.JpsJavaSdkTypeWrapper;
import org.jetbrains.jps.model.java.JpsProductionModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.JpsTestModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.impl.ExplodedDirectoryModuleExtensionImpl;
import org.jetbrains.jps.model.java.impl.JavaModuleExtensionRole;
import org.jetbrains.jps.model.java.impl.JavaModuleIndexImpl;
import org.jetbrains.jps.model.java.impl.JavaProjectExtensionRole;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesEnumeratorImpl;
import org.jetbrains.jps.model.java.impl.JpsJavaDependencyExtensionRole;
import org.jetbrains.jps.model.java.impl.JpsProductionModuleOutputPackagingElementImpl;
import org.jetbrains.jps.model.java.impl.JpsTestModuleOutputPackagingElementImpl;
import org.jetbrains.jps.model.java.impl.JpsWrappedJavaSdkReferenceImpl;
import org.jetbrains.jps.model.java.impl.compiler.JpsJavaCompilerConfigurationImpl;
import org.jetbrains.jps.model.java.impl.runConfiguration.JpsApplicationRunConfigurationPropertiesImpl;
import org.jetbrains.jps.model.java.runConfiguration.JpsApplicationRunConfigurationProperties;
import org.jetbrains.jps.model.java.runConfiguration.JpsApplicationRunConfigurationState;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsTestModuleProperties;
import org.jetbrains.jps.model.module.impl.JpsTestModulePropertiesImpl;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsJavaExtensionServiceImpl
extends JpsJavaExtensionService {
    private JavaModuleIndex myModuleIndex = null;

    @NotNull
    public JpsJavaProjectExtension getOrCreateProjectExtension(@NotNull JpsProject project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getOrCreateProjectExtension"));
        }
        JpsJavaProjectExtension jpsJavaProjectExtension = (JpsJavaProjectExtension)project2.getContainer().getOrSetChild((JpsElementChildRole)JavaProjectExtensionRole.INSTANCE);
        if (jpsJavaProjectExtension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getOrCreateProjectExtension"));
        }
        return jpsJavaProjectExtension;
    }

    @Nullable
    public JpsJavaProjectExtension getProjectExtension(@NotNull JpsProject project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getProjectExtension"));
        }
        return (JpsJavaProjectExtension)project2.getContainer().getChild((JpsElementChildRole)JavaProjectExtensionRole.INSTANCE);
    }

    @NotNull
    public JpsJavaModuleExtension getOrCreateModuleExtension(@NotNull JpsModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getOrCreateModuleExtension"));
        }
        JpsJavaModuleExtension jpsJavaModuleExtension = (JpsJavaModuleExtension)module2.getContainer().getOrSetChild((JpsElementChildRole)JavaModuleExtensionRole.INSTANCE);
        if (jpsJavaModuleExtension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getOrCreateModuleExtension"));
        }
        return jpsJavaModuleExtension;
    }

    @NotNull
    public JpsJavaDependencyExtension getOrCreateDependencyExtension(@NotNull JpsDependencyElement dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getOrCreateDependencyExtension"));
        }
        JpsJavaDependencyExtension jpsJavaDependencyExtension = (JpsJavaDependencyExtension)dependency.getContainer().getOrSetChild((JpsElementChildRole)JpsJavaDependencyExtensionRole.INSTANCE);
        if (jpsJavaDependencyExtension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getOrCreateDependencyExtension"));
        }
        return jpsJavaDependencyExtension;
    }

    public JpsJavaDependencyExtension getDependencyExtension(@NotNull JpsDependencyElement dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getDependencyExtension"));
        }
        return (JpsJavaDependencyExtension)dependency.getContainer().getChild((JpsElementChildRole)JpsJavaDependencyExtensionRole.INSTANCE);
    }

    @Nullable
    public JpsJavaModuleExtension getModuleExtension(@NotNull JpsModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getModuleExtension"));
        }
        return (JpsJavaModuleExtension)module2.getContainer().getChild((JpsElementChildRole)JavaModuleExtensionRole.INSTANCE);
    }

    @NotNull
    public ExplodedDirectoryModuleExtension getOrCreateExplodedDirectoryExtension(@NotNull JpsModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getOrCreateExplodedDirectoryExtension"));
        }
        ExplodedDirectoryModuleExtension explodedDirectoryModuleExtension = (ExplodedDirectoryModuleExtension)module2.getContainer().getOrSetChild((JpsElementChildRole)ExplodedDirectoryModuleExtensionImpl.ExplodedDirectoryModuleExtensionRole.INSTANCE);
        if (explodedDirectoryModuleExtension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getOrCreateExplodedDirectoryExtension"));
        }
        return explodedDirectoryModuleExtension;
    }

    @Nullable
    public ExplodedDirectoryModuleExtension getExplodedDirectoryExtension(@NotNull JpsModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getExplodedDirectoryExtension"));
        }
        return (ExplodedDirectoryModuleExtension)module2.getContainer().getChild((JpsElementChildRole)ExplodedDirectoryModuleExtensionImpl.ExplodedDirectoryModuleExtensionRole.INSTANCE);
    }

    @NotNull
    public List<JpsDependencyElement> getDependencies(JpsModule module2, JpsJavaClasspathKind classpathKind, boolean exportedOnly) {
        ArrayList<JpsDependencyElement> result2 = new ArrayList<JpsDependencyElement>();
        for (JpsDependencyElement dependencyElement : module2.getDependenciesList().getDependencies()) {
            JpsJavaDependencyExtension extension = this.getDependencyExtension(dependencyElement);
            if (extension != null && (!extension.getScope().isIncludedIn(classpathKind) || exportedOnly && !extension.isExported())) continue;
            result2.add(dependencyElement);
        }
        ArrayList<JpsDependencyElement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getDependencies"));
        }
        return arrayList;
    }

    public LanguageLevel getLanguageLevel(JpsModule module2) {
        JpsJavaModuleExtension moduleExtension = this.getModuleExtension(module2);
        if (moduleExtension == null) {
            return null;
        }
        LanguageLevel languageLevel = moduleExtension.getLanguageLevel();
        if (languageLevel != null) {
            return languageLevel;
        }
        JpsJavaProjectExtension projectExtension = this.getProjectExtension(module2.getProject());
        return projectExtension != null ? projectExtension.getLanguageLevel() : null;
    }

    public String getOutputUrl(JpsModule module2, boolean forTests) {
        JpsJavaModuleExtension extension = this.getModuleExtension(module2);
        if (extension == null) {
            return null;
        }
        if (extension.isInheritOutput()) {
            JpsJavaProjectExtension projectExtension = this.getProjectExtension(module2.getProject());
            if (projectExtension == null) {
                return null;
            }
            String url = projectExtension.getOutputUrl();
            if (url == null) {
                return null;
            }
            return url + "/" + (forTests ? "test" : "production") + "/" + module2.getName();
        }
        return forTests ? extension.getTestOutputUrl() : extension.getOutputUrl();
    }

    @Nullable
    public File getOutputDirectory(JpsModule module2, boolean forTests) {
        String url = this.getOutputUrl(module2, forTests);
        return url != null ? JpsPathUtil.urlToFile((String)url) : null;
    }

    public JpsTypedLibrary<JpsSdk<JpsDummyElement>> addJavaSdk(@NotNull JpsGlobal global, @NotNull String name, @NotNull String homePath) {
        if (global == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "addJavaSdk"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "addJavaSdk"));
        }
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "addJavaSdk"));
        }
        String version = JdkVersionDetector.getInstance().detectJdkVersion(homePath);
        JpsTypedLibrary sdk = global.addSdk(name, homePath, version, (JpsSdkType)JpsJavaSdkType.INSTANCE);
        File homeDir = new File(FileUtil.toSystemDependentName((String)homePath));
        List<File> roots = JavaSdkUtil.getJdkClassesRoots(homeDir, false);
        for (File root : roots) {
            sdk.addRoot(root, JpsOrderRootType.COMPILED);
        }
        return sdk;
    }

    @Nullable
    public JpsJavaCompilerConfiguration getCompilerConfiguration(@NotNull JpsProject project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getCompilerConfiguration"));
        }
        return (JpsJavaCompilerConfiguration)project2.getContainer().getChild(JpsJavaCompilerConfigurationImpl.ROLE);
    }

    @NotNull
    public JpsJavaCompilerConfiguration getOrCreateCompilerConfiguration(@NotNull JpsProject project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getOrCreateCompilerConfiguration"));
        }
        JpsJavaCompilerConfiguration configuration = this.getCompilerConfiguration(project2);
        if (configuration == null) {
            configuration = (JpsJavaCompilerConfiguration)project2.getContainer().setChild(JpsJavaCompilerConfigurationImpl.ROLE, (JpsElement)new JpsJavaCompilerConfigurationImpl());
        }
        JpsJavaCompilerConfiguration jpsJavaCompilerConfiguration = configuration;
        if (jpsJavaCompilerConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getOrCreateCompilerConfiguration"));
        }
        return jpsJavaCompilerConfiguration;
    }

    @Nullable
    public JpsTestModuleProperties getTestModuleProperties(@NotNull JpsModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getTestModuleProperties"));
        }
        return (JpsTestModuleProperties)module2.getContainer().getChild(JpsTestModulePropertiesImpl.ROLE);
    }

    public void setTestModuleProperties(@NotNull JpsModule module2, @NotNull JpsModuleReference productionModuleReference) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "setTestModuleProperties"));
        }
        if (productionModuleReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productionModuleReference", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "setTestModuleProperties"));
        }
        module2.getContainer().setChild(JpsTestModulePropertiesImpl.ROLE, (JpsElement)new JpsTestModulePropertiesImpl(productionModuleReference));
    }

    @NotNull
    public JpsSdkReference<JpsDummyElement> createWrappedJavaSdkReference(@NotNull JpsJavaSdkTypeWrapper sdkType, @NotNull JpsSdkReference<?> wrapperReference) {
        if (sdkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkType", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createWrappedJavaSdkReference"));
        }
        if (wrapperReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapperReference", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createWrappedJavaSdkReference"));
        }
        JpsWrappedJavaSdkReferenceImpl jpsWrappedJavaSdkReferenceImpl = new JpsWrappedJavaSdkReferenceImpl(sdkType, wrapperReference);
        if (jpsWrappedJavaSdkReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createWrappedJavaSdkReference"));
        }
        return jpsWrappedJavaSdkReferenceImpl;
    }

    @NotNull
    public JpsApplicationRunConfigurationProperties createRunConfigurationProperties(JpsApplicationRunConfigurationState state) {
        JpsApplicationRunConfigurationPropertiesImpl jpsApplicationRunConfigurationPropertiesImpl = new JpsApplicationRunConfigurationPropertiesImpl(state);
        if (jpsApplicationRunConfigurationPropertiesImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createRunConfigurationProperties"));
        }
        return jpsApplicationRunConfigurationPropertiesImpl;
    }

    @NotNull
    public JavaSourceRootProperties createSourceRootProperties(@NotNull String packagePrefix, boolean isGenerated) {
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createSourceRootProperties"));
        }
        JavaSourceRootProperties javaSourceRootProperties = new JavaSourceRootProperties(packagePrefix, isGenerated);
        if (javaSourceRootProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createSourceRootProperties"));
        }
        return javaSourceRootProperties;
    }

    @NotNull
    public JavaSourceRootProperties createSourceRootProperties(@NotNull String packagePrefix) {
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createSourceRootProperties"));
        }
        JavaSourceRootProperties javaSourceRootProperties = this.createSourceRootProperties(packagePrefix, false);
        if (javaSourceRootProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createSourceRootProperties"));
        }
        return javaSourceRootProperties;
    }

    @NotNull
    public JavaResourceRootProperties createResourceRootProperties(@NotNull String relativeOutputPath, boolean forGeneratedResource) {
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeOutputPath", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createResourceRootProperties"));
        }
        JavaResourceRootProperties javaResourceRootProperties = new JavaResourceRootProperties(relativeOutputPath, forGeneratedResource);
        if (javaResourceRootProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createResourceRootProperties"));
        }
        return javaResourceRootProperties;
    }

    @NotNull
    public JpsProductionModuleOutputPackagingElement createProductionModuleOutput(@NotNull JpsModuleReference moduleReference) {
        if (moduleReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReference", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createProductionModuleOutput"));
        }
        JpsProductionModuleOutputPackagingElementImpl jpsProductionModuleOutputPackagingElementImpl = new JpsProductionModuleOutputPackagingElementImpl(moduleReference);
        if (jpsProductionModuleOutputPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createProductionModuleOutput"));
        }
        return jpsProductionModuleOutputPackagingElementImpl;
    }

    @NotNull
    public JpsTestModuleOutputPackagingElement createTestModuleOutput(@NotNull JpsModuleReference moduleReference) {
        if (moduleReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReference", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createTestModuleOutput"));
        }
        JpsTestModuleOutputPackagingElementImpl jpsTestModuleOutputPackagingElementImpl = new JpsTestModuleOutputPackagingElementImpl(moduleReference);
        if (jpsTestModuleOutputPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "createTestModuleOutput"));
        }
        return jpsTestModuleOutputPackagingElementImpl;
    }

    public JpsJavaDependenciesEnumerator enumerateDependencies(Collection<JpsModule> modules) {
        return new JpsJavaDependenciesEnumeratorImpl(modules);
    }

    protected JpsJavaDependenciesEnumerator enumerateDependencies(JpsProject project2) {
        return new JpsJavaDependenciesEnumeratorImpl(project2.getModules());
    }

    protected JpsJavaDependenciesEnumerator enumerateDependencies(JpsModule module2) {
        return new JpsJavaDependenciesEnumeratorImpl(Collections.singletonList(module2));
    }

    @NotNull
    public JavaModuleIndex getJavaModuleIndex(@NotNull JpsProject project2, @NotNull File storageRoot) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getJavaModuleIndex"));
        }
        if (storageRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageRoot", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getJavaModuleIndex"));
        }
        if (this.myModuleIndex == null) {
            JpsCompilerExcludes excludes = this.getOrCreateCompilerConfiguration(project2).getCompilerExcludes();
            this.myModuleIndex = JavaModuleIndexImpl.load(storageRoot, excludes);
        }
        JavaModuleIndex javaModuleIndex = this.myModuleIndex;
        if (javaModuleIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl", "getJavaModuleIndex"));
        }
        return javaModuleIndex;
    }
}

