/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.JpsJavaSdkTypeWrapper;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;

public class JpsWrappedJavaSdkReferenceImpl
extends JpsCompositeElementBase<JpsWrappedJavaSdkReferenceImpl>
implements JpsSdkReference<JpsDummyElement> {
    private static final JpsElementChildRoleBase<JpsSdkReference<?>> WRAPPER_ROLE = JpsElementChildRoleBase.create((String)"wrapper reference");
    private final JpsJavaSdkTypeWrapper mySdkType;

    public JpsWrappedJavaSdkReferenceImpl(JpsJavaSdkTypeWrapper sdkType, JpsSdkReference<?> wrapperReference) {
        this.mySdkType = sdkType;
        this.myContainer.setChild(WRAPPER_ROLE, wrapperReference);
    }

    private JpsWrappedJavaSdkReferenceImpl(JpsWrappedJavaSdkReferenceImpl original) {
        super((JpsCompositeElementBase)original);
        this.mySdkType = original.mySdkType;
    }

    @NotNull
    public JpsWrappedJavaSdkReferenceImpl createCopy() {
        JpsWrappedJavaSdkReferenceImpl jpsWrappedJavaSdkReferenceImpl = new JpsWrappedJavaSdkReferenceImpl(this);
        if (jpsWrappedJavaSdkReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsWrappedJavaSdkReferenceImpl", "createCopy"));
        }
        return jpsWrappedJavaSdkReferenceImpl;
    }

    public String getSdkName() {
        JpsTypedLibrary<JpsSdk<JpsDummyElement>> sdk = this.resolve();
        return sdk != null ? sdk.getName() : "<unknown>";
    }

    @Nullable
    public JpsTypedLibrary<JpsSdk<JpsDummyElement>> resolve() {
        JpsTypedLibrary wrapper = (JpsTypedLibrary)((JpsSdkReference)this.myContainer.getChild(WRAPPER_ROLE)).resolve();
        if (wrapper == null) {
            return null;
        }
        JpsModel model2 = this.getModel();
        if (model2 == null) {
            return null;
        }
        String sdkName = this.mySdkType.getJavaSdkName(((JpsSdk)wrapper.getProperties()).getSdkProperties());
        if (sdkName == null) {
            return null;
        }
        JpsLibrary library = model2.getGlobal().getLibraryCollection().findLibrary(sdkName);
        return library != null ? library.asTyped((JpsLibraryType)JpsJavaSdkType.INSTANCE) : null;
    }

    public JpsElementReference<JpsTypedLibrary<JpsSdk<JpsDummyElement>>> asExternal(@NotNull JpsModel model2) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/model/java/impl/JpsWrappedJavaSdkReferenceImpl", "asExternal"));
        }
        model2.registerExternalReference((JpsElementReference)this);
        return this;
    }
}

