/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.module.JpsDependenciesEnumerator;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceDependency;
import org.jetbrains.jps.model.module.JpsSdkDependency;

public abstract class JpsDependenciesEnumeratorBase<Self extends JpsDependenciesEnumerator>
implements JpsDependenciesEnumerator {
    private boolean myWithoutSdk;
    private boolean myWithoutLibraries;
    protected boolean myWithoutDepModules;
    private boolean myWithoutModuleSourceEntries;
    protected boolean myRecursively;
    protected final Collection<JpsModule> myRootModules;
    private Condition<JpsDependencyElement> myCondition;

    protected JpsDependenciesEnumeratorBase(Collection<JpsModule> rootModules) {
        this.myRootModules = rootModules;
    }

    @NotNull
    public Self withoutLibraries() {
        this.myWithoutLibraries = true;
        Self Self = this.self();
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase", "withoutLibraries"));
        }
        return Self;
    }

    @NotNull
    public Self withoutDepModules() {
        this.myWithoutDepModules = true;
        Self Self = this.self();
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase", "withoutDepModules"));
        }
        return Self;
    }

    @NotNull
    public Self withoutSdk() {
        this.myWithoutSdk = true;
        Self Self = this.self();
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase", "withoutSdk"));
        }
        return Self;
    }

    @NotNull
    public Self withoutModuleSourceEntries() {
        this.myWithoutModuleSourceEntries = true;
        Self Self = this.self();
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase", "withoutModuleSourceEntries"));
        }
        return Self;
    }

    @NotNull
    public Self satisfying(@NotNull Condition<JpsDependencyElement> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase", "satisfying"));
        }
        this.myCondition = condition;
        Self Self = this.self();
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase", "satisfying"));
        }
        return Self;
    }

    @NotNull
    public Self recursively() {
        this.myRecursively = true;
        Self Self = this.self();
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase", "recursively"));
        }
        return Self;
    }

    protected abstract Self self();

    @NotNull
    public Set<JpsModule> getModules() {
        LinkedHashSet<JpsModule> result2 = new LinkedHashSet<JpsModule>();
        this.processModules((Consumer<JpsModule>)new CollectConsumer(result2));
        LinkedHashSet<JpsModule> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase", "getModules"));
        }
        return linkedHashSet;
    }

    public void processModules(@NotNull Consumer<JpsModule> consumer2) {
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase", "processModules"));
        }
        this.processModuleAndLibraries(consumer2, (Consumer<JpsLibrary>)Consumer.EMPTY_CONSUMER);
    }

    protected boolean shouldProcessDependenciesRecursively() {
        return true;
    }

    public boolean processDependencies(Processor<JpsDependencyElement> processor2) {
        THashSet processed2 = new THashSet();
        for (JpsModule module2 : this.myRootModules) {
            if (this.doProcessDependencies(module2, processor2, (Set<JpsModule>)processed2)) continue;
            return false;
        }
        return true;
    }

    private boolean doProcessDependencies(JpsModule module2, Processor<JpsDependencyElement> processor2, Set<JpsModule> processed2) {
        if (!processed2.add(module2)) {
            return true;
        }
        for (JpsDependencyElement element : module2.getDependenciesList().getDependencies()) {
            if (this.myCondition != null && !this.myCondition.value((Object)element) || this.myWithoutSdk && element instanceof JpsSdkDependency || this.myWithoutLibraries && element instanceof JpsLibraryDependency || this.myWithoutModuleSourceEntries && element instanceof JpsModuleSourceDependency || this.myWithoutDepModules && (!this.myRecursively && element instanceof JpsModuleDependency || element instanceof JpsModuleSourceDependency && !this.isEnumerationRootModule(module2)) || !this.shouldProcess(module2, element)) continue;
            if (element instanceof JpsModuleDependency) {
                JpsModule depModule;
                if (this.myRecursively && this.shouldProcessDependenciesRecursively() && (depModule = ((JpsModuleDependency)element).getModule()) != null) {
                    this.doProcessDependencies(depModule, processor2, processed2);
                    continue;
                }
                if (this.myWithoutDepModules) continue;
            }
            if (processor2.process((Object)element)) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldProcess(JpsModule module2, JpsDependencyElement element) {
        return true;
    }

    public boolean isEnumerationRootModule(JpsModule module2) {
        return this.myRootModules.contains(module2);
    }

    @NotNull
    public Set<JpsLibrary> getLibraries() {
        LinkedHashSet<JpsLibrary> libraries = new LinkedHashSet<JpsLibrary>();
        this.processLibraries((Consumer<JpsLibrary>)new CollectConsumer(libraries));
        LinkedHashSet<JpsLibrary> linkedHashSet = libraries;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase", "getLibraries"));
        }
        return linkedHashSet;
    }

    public void processLibraries(@NotNull Consumer<JpsLibrary> consumer2) {
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase", "processLibraries"));
        }
        this.processModuleAndLibraries((Consumer<JpsModule>)Consumer.EMPTY_CONSUMER, consumer2);
    }

    public void processModuleAndLibraries(@Nullable Consumer<JpsModule> moduleConsumer, @Nullable Consumer<JpsLibrary> libraryConsumer) {
        this.processDependencies((Processor<JpsDependencyElement>)((Processor)dependencyElement -> {
            JpsLibrary library;
            if (moduleConsumer != null) {
                JpsModule module2;
                if (this.myRecursively && dependencyElement instanceof JpsModuleSourceDependency) {
                    moduleConsumer.consume((Object)dependencyElement.getContainingModule());
                } else if (!(this.myRecursively && this.shouldProcessDependenciesRecursively() || !(dependencyElement instanceof JpsModuleDependency) || (module2 = ((JpsModuleDependency)dependencyElement).getModule()) == null)) {
                    moduleConsumer.consume((Object)module2);
                }
            }
            if (libraryConsumer != null && dependencyElement instanceof JpsLibraryDependency && (library = ((JpsLibraryDependency)dependencyElement).getLibrary()) != null) {
                libraryConsumer.consume((Object)library);
            }
            return true;
        }));
    }
}

