/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.serialization.CannotLoadJpsModelException;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsElementExtensionSerializerBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;

public abstract class JpsLoaderBase {
    private static final Logger LOG = Logger.getInstance(JpsLoaderBase.class);
    private static final int MAX_ATTEMPTS = 5;
    private final JpsMacroExpander myMacroExpander;

    protected JpsLoaderBase(JpsMacroExpander macroExpander) {
        this.myMacroExpander = macroExpander;
    }

    protected Element loadRootElement(File file2) {
        return JpsLoaderBase.loadRootElement(file2, this.myMacroExpander);
    }

    protected <E extends JpsElement> void loadComponents(File dir, String defaultFileName, JpsElementExtensionSerializerBase<E> serializer2, E element) {
        String fileName = serializer2.getConfigFileName();
        File configFile = new File(dir, fileName != null ? fileName : defaultFileName);
        Runnable timingLog = TimingLog.startActivity("loading: " + configFile.getName() + ":" + serializer2.getComponentName());
        Element componentTag = configFile.exists() ? JDomSerializationUtil.findComponent(this.loadRootElement(configFile), serializer2.getComponentName()) : null;
        if (componentTag != null) {
            serializer2.loadExtension(element, componentTag);
        } else {
            serializer2.loadExtensionWithDefaultSettings(element);
        }
        timingLog.run();
    }

    protected static Element loadRootElement(File file2, JpsMacroExpander macroExpander) {
        try {
            Element element = JpsLoaderBase.tryLoadRootElement(file2);
            macroExpander.substitute(element, SystemInfo.isFileSystemCaseSensitive);
            return element;
        }
        catch (JDOMException e2) {
            throw new CannotLoadJpsModelException(file2, "Cannot parse xml file " + file2.getAbsolutePath() + ": " + e2.getMessage(), e2);
        }
        catch (IOException e3) {
            throw new CannotLoadJpsModelException(file2, "Cannot read file " + file2.getAbsolutePath() + ": " + e3.getMessage(), e3);
        }
    }

    private static Element tryLoadRootElement(File file2) throws IOException, JDOMException {
        for (int i2 = 0; i2 < 4; ++i2) {
            try {
                return JDOMUtil.load((File)file2);
            }
            catch (Exception e2) {
                LOG.info("Loading attempt #" + i2 + " failed", (Throwable)e2);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return JDOMUtil.load((File)file2);
    }
}

