/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class JpsMacroExpander {
    private ExpandMacroToPathMap myExpandMacroMap = new ExpandMacroToPathMap();

    public JpsMacroExpander(Map<String, String> pathVariables) {
        for (Map.Entry<String, String> entry : pathVariables.entrySet()) {
            this.addMacro(entry.getKey(), entry.getValue());
        }
    }

    public void addFileHierarchyReplacements(String macroName, File file2) {
        this.doAddFileHierarchyReplacements("$" + macroName + "$", file2);
    }

    protected void addMacro(String macroName, String path) {
        this.myExpandMacroMap.addMacroExpand(macroName, path);
    }

    private void doAddFileHierarchyReplacements(String macro2, @Nullable File file2) {
        if (file2 == null) {
            return;
        }
        this.doAddFileHierarchyReplacements(macro2 + "/..", file2.getParentFile());
        String path = FileUtil.toSystemIndependentName((String)file2.getPath());
        if (StringUtil.endsWithChar((CharSequence)path, (char)'/')) {
            this.myExpandMacroMap.put(macro2 + "/", path);
            this.myExpandMacroMap.put(macro2, path.substring(0, path.length() - 1));
        } else {
            this.myExpandMacroMap.put(macro2, path);
        }
    }

    public void substitute(Element element, boolean caseSensitive) {
        this.myExpandMacroMap.substitute(element, caseSensitive);
    }

    public ExpandMacroToPathMap getExpandMacroMap() {
        return this.myExpandMacroMap;
    }

    public String substitute(String element, boolean caseSensitive) {
        return this.myExpandMacroMap.substitute(element, caseSensitive);
    }
}

