/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsGlobalLoader;
import org.jetbrains.jps.model.serialization.JpsPathVariablesConfiguration;
import org.jetbrains.jps.model.serialization.JpsProjectSerializationDataExtension;
import org.jetbrains.jps.model.serialization.PathMacroUtil;
import org.jetbrains.jps.model.serialization.impl.JpsModuleSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.impl.JpsPathVariablesConfigurationImpl;
import org.jetbrains.jps.model.serialization.impl.JpsProjectSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.module.JpsModuleSerializationDataExtension;

public class JpsModelSerializationDataService {
    @NotNull
    public static Map<String, String> getAllPathVariables(JpsGlobal global) {
        Map<String, String> map2 = JpsModelSerializationDataService.computeAllPathVariables(global);
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializationDataService", "getAllPathVariables"));
        }
        return map2;
    }

    public static Map<String, String> computeAllPathVariables(JpsGlobal global) {
        HashMap<String, String> pathVariables = new HashMap<String, String>(PathMacroUtil.getGlobalSystemMacros());
        JpsPathVariablesConfiguration configuration = JpsModelSerializationDataService.getPathVariablesConfiguration(global);
        if (configuration != null) {
            pathVariables.putAll(configuration.getAllUserVariables());
        }
        return pathVariables;
    }

    @Nullable
    public static JpsPathVariablesConfiguration getPathVariablesConfiguration(JpsGlobal global) {
        return (JpsPathVariablesConfiguration)global.getContainer().getChild(JpsGlobalLoader.PATH_VARIABLES_ROLE);
    }

    @NotNull
    public static JpsPathVariablesConfiguration getOrCreatePathVariablesConfiguration(JpsGlobal global) {
        JpsPathVariablesConfiguration child = (JpsPathVariablesConfiguration)global.getContainer().getChild(JpsGlobalLoader.PATH_VARIABLES_ROLE);
        if (child == null) {
            JpsPathVariablesConfiguration jpsPathVariablesConfiguration = (JpsPathVariablesConfiguration)global.getContainer().setChild(JpsGlobalLoader.PATH_VARIABLES_ROLE, (JpsElement)new JpsPathVariablesConfigurationImpl());
            if (jpsPathVariablesConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializationDataService", "getOrCreatePathVariablesConfiguration"));
            }
            return jpsPathVariablesConfiguration;
        }
        JpsPathVariablesConfiguration jpsPathVariablesConfiguration = child;
        if (jpsPathVariablesConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializationDataService", "getOrCreatePathVariablesConfiguration"));
        }
        return jpsPathVariablesConfiguration;
    }

    @Nullable
    public static JpsProjectSerializationDataExtension getProjectExtension(@NotNull JpsProject project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/JpsModelSerializationDataService", "getProjectExtension"));
        }
        return (JpsProjectSerializationDataExtension)project2.getContainer().getChild(JpsProjectSerializationDataExtensionImpl.ROLE);
    }

    @Nullable
    public static File getBaseDirectory(@NotNull JpsProject project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/JpsModelSerializationDataService", "getBaseDirectory"));
        }
        JpsProjectSerializationDataExtension extension = JpsModelSerializationDataService.getProjectExtension(project2);
        return extension != null ? extension.getBaseDirectory() : null;
    }

    @Nullable
    public static JpsModuleSerializationDataExtension getModuleExtension(@NotNull JpsModule project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/JpsModelSerializationDataService", "getModuleExtension"));
        }
        return (JpsModuleSerializationDataExtension)project2.getContainer().getChild(JpsModuleSerializationDataExtensionImpl.ROLE);
    }

    @Nullable
    public static File getBaseDirectory(@NotNull JpsModule module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/model/serialization/JpsModelSerializationDataService", "getBaseDirectory"));
        }
        JpsModuleSerializationDataExtension extension = JpsModelSerializationDataService.getModuleExtension(module2);
        return extension != null ? extension.getBaseDirectory() : null;
    }

    @Nullable
    public static String getPathVariableValue(@NotNull JpsGlobal global, @NotNull String name) {
        if (global == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/serialization/JpsModelSerializationDataService", "getPathVariableValue"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/serialization/JpsModelSerializationDataService", "getPathVariableValue"));
        }
        String value2 = PathMacroUtil.getGlobalSystemMacroValue(name);
        if (value2 != null) {
            return value2;
        }
        JpsPathVariablesConfiguration configuration = JpsModelSerializationDataService.getPathVariablesConfiguration(global);
        return configuration != null ? configuration.getUserVariableValue(name) : null;
    }
}

